/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity.libs.lang.velocity;

import com.google.common.reflect.TypeToken;
import de.themoep.resourcepacksplugin.velocity.libs.lang.LanguageConfig;
import de.themoep.resourcepacksplugin.velocity.libs.lang.velocity.Languaged;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.kyori.text.format.TextColor;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ValueType;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;

public class VelocityLanguageConfig
extends LanguageConfig<ConfigurationNode> {
    private static final Pattern KEY_PATTERN = Pattern.compile("\\.");
    private final Languaged plugin;

    public VelocityLanguageConfig(Languaged plugin, String resourceFolder, File configFile, String locale) {
        this(plugin, resourceFolder, configFile, locale, true);
    }

    public VelocityLanguageConfig(Languaged plugin, String resourceFolder, File configFile, String locale, boolean saveFile) {
        super(resourceFolder, configFile, locale, saveFile);
        this.plugin = plugin;
        this.saveConfigResource();
        this.loadConfig();
    }

    @Override
    public void loadConfig() {
        if (this.configFile != null && this.configFile.exists()) {
            try {
                this.config = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setIndent(2).setPath(this.configFile.toPath())).build().load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveConfigResource() {
        block15: {
            try (InputStream in = this.plugin.getResourceAsStream(this.resourcePath);){
                if (in == null) {
                    if (Boolean.getBoolean("de.themoep.resourcepacksplugin.velocity.libs.lang.debug")) {
                        this.plugin.getLangLogger().log(Level.WARNING, "No default config '" + this.resourcePath + "' found in " + this.plugin.getName() + "!");
                    }
                    boolean bl = false;
                    return bl;
                }
                this.defaultConfig = this.config = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setIndent(2).setSource(() -> new BufferedReader(new InputStreamReader(in)))).build().load();
                if (!this.saveFile || this.configFile.exists()) break block15;
                File parent = this.configFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    Files.copy(this.plugin.getResourceAsStream(this.resourcePath), this.configFile.toPath(), new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.getLangLogger().log(Level.SEVERE, "Could not save " + this.configFile.getName() + " to " + this.configFile, ex);
                }
            }
            catch (IOException ex) {
                this.plugin.getLangLogger().log(Level.SEVERE, "Could not load default config from " + this.resourcePath, ex);
            }
        }
        return false;
    }

    @Override
    public boolean contains(String key) {
        return this.contains(key, false);
    }

    @Override
    public boolean contains(String key, boolean checkDefault) {
        return !((ConfigurationNode)this.config).getNode(VelocityLanguageConfig.splitKey(key)).isVirtual() || checkDefault && this.defaultConfig != null && !((ConfigurationNode)this.defaultConfig).getNode(VelocityLanguageConfig.splitKey(key)).isVirtual();
    }

    @Override
    public String get(String key) {
        ConfigurationNode o = ((ConfigurationNode)this.config).getNode(VelocityLanguageConfig.splitKey(key));
        if (o.isVirtual() && this.defaultConfig != null) {
            o = ((ConfigurationNode)this.defaultConfig).getNode(VelocityLanguageConfig.splitKey(key));
        }
        String string = null;
        if (o.getValueType() == ValueType.LIST) {
            try {
                List stringList = o.getList(TypeToken.of(String.class));
                string = String.join((CharSequence)"\n", stringList);
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        } else {
            string = o.getString();
        }
        if (string == null) {
            return TextColor.RED + "Missing language key " + TextColor.YELLOW + key + TextColor.RED + " for locale " + TextColor.YELLOW + this.getLocale();
        }
        return string;
    }

    @Override
    public ConfigurationNode getRawConfig() {
        return (ConfigurationNode)this.config;
    }

    private static Object[] splitKey(String key) {
        return KEY_PATTERN.split(key);
    }
}

