/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity.listeners;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CurrentServerTracker {
    private final ResourcepacksPlugin plugin;
    private final Map<UUID, String> currentServer = new ConcurrentHashMap<UUID, String>();

    public CurrentServerTracker(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.LAST)
    public void onServerConnect(ServerPreConnectEvent event) {
        if (this.plugin.isEnabled() && event.getResult().getServer().isPresent()) {
            this.plugin.logDebug("Player " + event.getPlayer().getUsername() + " is connecting to server " + ((RegisteredServer)event.getResult().getServer().get()).getServerInfo().getName());
            this.currentServer.put(event.getPlayer().getUniqueId(), ((RegisteredServer)event.getResult().getServer().get()).getServerInfo().getName());
        }
    }

    @Subscribe
    public void onPlayerDisconnect(DisconnectEvent event) {
        this.currentServer.remove(event.getPlayer().getUniqueId());
    }

    @Subscribe
    public void onServerSwitch(ServerPostConnectEvent event) {
        if (this.plugin.isEnabled()) {
            this.currentServer.remove(event.getPlayer().getUniqueId());
        }
    }

    public String getCurrentServer(Player player) {
        if (player.getCurrentServer().isPresent()) {
            return ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName();
        }
        return this.currentServer.get(player.getUniqueId());
    }
}

