/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity.listeners;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.velocitypowered.api.event.AwaitingEventExecutor;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.configuration.PlayerConfigurationEvent;
import com.velocitypowered.api.event.player.configuration.PlayerFinishConfigurationEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.velocity.VelocityResourcepacks;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerSwitchListener {
    private final VelocityResourcepacks plugin;
    private final Set<UUID> appliedInConfigPhase = ConcurrentHashMap.newKeySet();
    private final Multimap<UUID, UUID> alreadyAppliedPacks = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);
    private final Table<UUID, UUID, CompletableFuture<Boolean>> playersLoadingPacks = Tables.synchronizedTable((Table)HashBasedTable.create());

    public ServerSwitchListener(VelocityResourcepacks plugin) {
        this.plugin = plugin;
        try {
            plugin.getProxy().getEventManager().register((Object)plugin, PlayerConfigurationEvent.class, (EventHandler)new AwaitingEventExecutor<PlayerConfigurationEvent>(){

                public @Nullable EventTask executeAsync(PlayerConfigurationEvent event) {
                    return ServerSwitchListener.this.onConfigPhase(event.player());
                }
            });
        }
        catch (NoClassDefFoundError e1) {
            try {
                plugin.getProxy().getEventManager().register((Object)plugin, PlayerFinishConfigurationEvent.class, (EventHandler)new AwaitingEventExecutor<PlayerFinishConfigurationEvent>(){

                    public @Nullable EventTask executeAsync(PlayerFinishConfigurationEvent event) {
                        return ServerSwitchListener.this.onConfigPhase(event.player());
                    }
                });
            }
            catch (NoClassDefFoundError e2) {
                plugin.getPluginLogger().log(Level.WARNING, "Configuration phase API is not available, resource packs will only be sent after login! Update Velocity if you want support for it.");
                plugin.getPluginLogger().log(Level.WARNING, "PlayerConfigurationEvent error:", e1);
                plugin.getPluginLogger().log(Level.WARNING, "PlayerFinishConfigurationEvent error:", e2);
            }
        }
    }

    public EventTask onConfigPhase(Player player) {
        if (this.plugin.isEnabled()) {
            Set<ResourcePack> packs;
            UUID playerId = player.getUniqueId();
            this.plugin.unsetBackend(playerId);
            long sendDelay = -1L;
            String serverName = this.plugin.getCurrentServerTracker().getCurrentServer(player);
            if (serverName != null) {
                sendDelay = this.plugin.getPackManager().getAssignment(serverName).getSendDelay();
            }
            if (sendDelay < 0L) {
                sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
            }
            if (sendDelay <= 0L && !(packs = this.calculatePack(playerId)).isEmpty()) {
                CompletionStage<Boolean> lockFuture = CompletableFuture.completedFuture(true);
                for (ResourcePack pack : packs) {
                    if (this.hasPack(player, pack)) {
                        this.plugin.logDebug("Player " + player.getUsername() + " already has the pack " + String.valueOf(pack.getUuid()) + " applied");
                        continue;
                    }
                    CompletableFuture future = new CompletableFuture();
                    future.whenComplete((success, throwable) -> {
                        if (success.booleanValue()) {
                            this.plugin.logDebug("Successfully sent pack " + String.valueOf(pack.getUuid()) + " to " + player.getUsername());
                        } else {
                            this.plugin.logDebug("Failed to send pack " + String.valueOf(pack.getUuid()) + " to " + player.getUsername());
                        }
                    });
                    this.playersLoadingPacks.put((Object)playerId, (Object)pack.getUuid(), future);
                    lockFuture = lockFuture.thenCombine((CompletionStage)future, (a, b) -> a != false && b != false);
                }
                String playerName = player.getUsername();
                return EventTask.resumeWhenComplete((CompletableFuture)lockFuture.thenAccept(success -> {
                    this.alreadyAppliedPacks.removeAll((Object)playerId);
                    this.appliedInConfigPhase.add(playerId);
                    if (success.booleanValue()) {
                        this.plugin.logDebug("Allowing Configuration phase to continue for " + playerName);
                    } else {
                        this.plugin.logDebug("Allowing Configuration phase even through we failed to send all packs to " + playerName);
                    }
                }));
            }
        }
        return null;
    }

    private boolean hasPack(Player player, ResourcePack pack) {
        if (this.alreadyAppliedPacks.containsEntry((Object)player.getUniqueId(), (Object)pack.getUuid())) {
            return true;
        }
        for (ResourcePackInfo resourcePack : player.getAppliedResourcePacks()) {
            if (!resourcePack.getId().equals(pack.getUuid()) || !resourcePack.getUrl().equals(pack.getUrl())) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onPlayerDisconnect(DisconnectEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.appliedInConfigPhase.remove(playerId);
        this.alreadyAppliedPacks.removeAll((Object)playerId);
        Map futures = (Map)this.playersLoadingPacks.rowMap().remove(playerId);
        if (futures != null) {
            for (CompletableFuture future : futures.values()) {
                future.complete(false);
            }
        }
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onPackStatusFirst(PlayerResourcePackStatusEvent event) {
        if (!event.getStatus().isIntermediate() && event.getPackId() != null) {
            this.alreadyAppliedPacks.put((Object)event.getPlayer().getUniqueId(), (Object)event.getPackId());
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPackStatusLast(PlayerResourcePackStatusEvent event) {
        CompletableFuture future;
        if (!event.getStatus().isIntermediate() && (future = (CompletableFuture)this.playersLoadingPacks.remove((Object)event.getPlayer().getUniqueId(), (Object)event.getPackId())) != null) {
            future.complete(event.getStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFUL);
        }
    }

    @Subscribe
    public void onServerSwitch(ServerPostConnectEvent event) {
        if (this.plugin.isEnabled()) {
            UUID playerId = event.getPlayer().getUniqueId();
            this.plugin.unsetBackend(playerId);
            this.plugin.sendPackInfo(playerId);
            long sendDelay = -1L;
            String serverName = this.plugin.getCurrentServerTracker().getCurrentServer(event.getPlayer());
            if (serverName != null) {
                sendDelay = this.plugin.getPackManager().getAssignment(serverName).getSendDelay();
            }
            if (sendDelay < 0L) {
                sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
            }
            if (sendDelay > 0L) {
                this.plugin.getProxy().getScheduler().buildTask((Object)this.plugin, () -> this.calculatePack(playerId)).delay(sendDelay * 50L, TimeUnit.MILLISECONDS).schedule();
            } else if (!this.appliedInConfigPhase.contains(playerId)) {
                this.calculatePack(playerId);
            }
            this.appliedInConfigPhase.remove(playerId);
        }
    }

    private Set<ResourcePack> calculatePack(UUID playerId) {
        if (this.plugin.hasBackend(playerId)) {
            this.plugin.logDebug("Player " + String.valueOf(playerId) + " has backend pack, not attempting to send a new one.");
            return Collections.emptySet();
        }
        if (!this.plugin.isAuthenticated(playerId)) {
            this.plugin.logDebug("Player " + String.valueOf(playerId) + " is not authenticated, not attempting to send a pack yet.");
            return Collections.emptySet();
        }
        Optional player = this.plugin.getProxy().getPlayer(playerId);
        if (player.isPresent()) {
            Player p = (Player)player.get();
            String serverName = this.plugin.getCurrentServerTracker().getCurrentServer(p);
            return this.plugin.getPackManager().applyPack(this.plugin.getPlayer(p), serverName);
        }
        return Collections.emptySet();
    }
}

