/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.io.BaseEncoding;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class ResourcePack {
    private final String name;
    private UUID uuid;
    private String url;
    private String localPath;
    private byte[] hash;
    private int[] format;
    private int version;
    private boolean restricted;
    private String permission;
    private ClientType type;
    private final ResourcePack parent;
    private final List<ResourcePack> variants;

    public ResourcePack(String name, String url, String hash) {
        this(name, url, hash, 0);
    }

    public ResourcePack(String name, UUID uuid, String url, String hash) {
        this(name, url, hash, new int[0]);
        this.uuid = uuid;
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, int format) {
        this(name, url, hash, format, false);
    }

    public ResourcePack(String name, String url, String hash, int[] format) {
        this(name, url, hash, format, false);
    }

    public ResourcePack(String name, String url, String hash, boolean restricted) {
        this(name, url, hash, new int[0], restricted);
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, int format, boolean restricted) {
        this(name, url, hash, format, restricted, "resourcepacksplugin.pack." + name.toLowerCase(Locale.ROOT));
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, int[] format, boolean restricted) {
        this(name, url, hash, format, restricted, "resourcepacksplugin.pack." + name.toLowerCase(Locale.ROOT));
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, int format, boolean restricted, String permission) {
        this(name, url, hash, format, 0, restricted, permission);
    }

    public ResourcePack(String name, String url, String hash, int[] format, boolean restricted, String permission) {
        this(name, url, hash, format, 0, restricted, permission);
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, int format, int version, boolean restricted, String permission) {
        this(name, url, hash, format, version, restricted, permission, ClientType.ORIGINAL);
    }

    public ResourcePack(String name, String url, String hash, int[] format, int version, boolean restricted, String permission) {
        this(name, url, hash, format, version, restricted, permission, ClientType.ORIGINAL);
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, int format, int version, boolean restricted, String permission, ClientType type) {
        this(name, url, hash, null, format, version, restricted, permission, type);
    }

    public ResourcePack(String name, String url, String hash, int[] format, int version, boolean restricted, String permission, ClientType type) {
        this(name, url, hash, null, format, version, restricted, permission, type);
    }

    @Deprecated
    public ResourcePack(String name, String url, String hash, String localPath, int format, int version, boolean restricted, String permission, ClientType type) {
        this(name, UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8)), url, hash, localPath, format, version, restricted, permission, type);
    }

    public ResourcePack(String name, String url, String hash, String localPath, int[] format, int version, boolean restricted, String permission, ClientType type) {
        this(name, UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8)), url, hash, localPath, format, version, restricted, permission, type);
    }

    @Deprecated
    public ResourcePack(String name, UUID uuid, String url, String hash, String localPath, int format, int version, boolean restricted, String permission, ClientType type) {
        this(null, name, uuid, url, hash, localPath, format, version, restricted, permission, type);
    }

    public ResourcePack(String name, UUID uuid, String url, String hash, String localPath, int[] format, int version, boolean restricted, String permission, ClientType type) {
        this(null, name, uuid, url, hash, localPath, format, version, restricted, permission, type);
    }

    @Deprecated
    public ResourcePack(ResourcePack parent, String name, UUID uuid, String url, String hash, String localPath, int format, int version, boolean restricted, String permission, ClientType type) {
        int[] nArray;
        if (format > 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = format;
        } else {
            nArray = new int[]{};
        }
        this(parent, name, uuid, url, hash, localPath, nArray, version, restricted, permission, type);
    }

    public ResourcePack(ResourcePack parent, String name, UUID uuid, String url, String hash, String localPath, int[] format, int version, boolean restricted, String permission, ClientType type) {
        this.hash = new byte[0];
        this.variants = new ArrayList<ResourcePack>();
        this.parent = parent;
        this.name = name;
        this.uuid = uuid;
        this.url = url;
        if (hash != null && !hash.isEmpty() && !"null".equals(hash)) {
            this.setHash(hash);
        }
        this.localPath = localPath;
        this.format = format;
        this.version = version;
        this.restricted = restricted;
        this.permission = permission;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public String getHash() {
        return BaseEncoding.base16().lowerCase().encode(this.hash);
    }

    void setHash(String hash) {
        this.setRawHash(BaseEncoding.base16().lowerCase().decode((CharSequence)hash.toLowerCase(Locale.ROOT)));
    }

    public byte[] getRawHash() {
        return this.hash;
    }

    public void setRawHash(byte[] hash) {
        if (hash.length > 0 && hash.length != 20) {
            throw new IllegalArgumentException("Hash needs to be either 0 or 20 bytes long!");
        }
        this.hash = hash;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public int[] getFormatArray() {
        return this.format;
    }

    public boolean setFormatArray(int[] format) {
        if (PackManager.compareVersionTo(this.format, format) == 0) {
            return false;
        }
        this.format = format;
        return true;
    }

    @Deprecated
    public int getFormat() {
        return this.format[0];
    }

    @Deprecated
    public boolean setFormat(int format) {
        if (this.format.length == 1 && this.format[0] == format) {
            return false;
        }
        this.format = new int[]{format};
        return true;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean setVersion(int version) {
        if (this.version == version) {
            return false;
        }
        this.version = version;
        return true;
    }

    public boolean setVersion(String versionString) {
        int mcVersion = 0;
        try {
            mcVersion = MinecraftVersion.parseVersion(versionString).getProtocolNumber();
        }
        catch (IllegalArgumentException e) {
            try {
                mcVersion = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("'" + versionString + "' is not a valid Minecraft version string nor protocol number");
            }
        }
        return this.setVersion(mcVersion);
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean setRestricted(boolean restricted) {
        if (this.restricted == restricted) {
            return false;
        }
        this.restricted = restricted;
        return true;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean setPermission(String permission) {
        if (this.permission.equals(permission)) {
            return false;
        }
        this.permission = permission;
        return true;
    }

    public ClientType getType() {
        return this.type;
    }

    public boolean setType(ClientType type) {
        if (this.type == type) {
            return false;
        }
        this.type = type;
        return true;
    }

    public ResourcePack getParent() {
        return this.parent;
    }

    public ResourcePack getRootParent() {
        ResourcePack root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public List<ResourcePack> getVariants() {
        return this.variants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePack pack = (ResourcePack)o;
        return PackManager.compareVersionTo(this.format, pack.format) == 0 && this.version == pack.version && this.restricted == pack.restricted && Objects.equals(this.name, pack.name) && Objects.equals(this.uuid, pack.uuid) && Objects.equals(this.url, pack.url) && Objects.equals(this.localPath, pack.localPath) && Arrays.equals(this.hash, pack.hash) && Objects.equals(this.permission, pack.permission) && this.type == pack.type && Objects.equals(this.variants, pack.variants);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.uuid, this.url, this.localPath, Arrays.hashCode(this.format), this.version, this.restricted, this.permission, this.type, this.variants, Arrays.hashCode(this.hash)});
    }

    public String[] getReplacements() {
        return new String[]{"name", this.getName(), "uuid", this.getUuid() != null ? this.getUuid().toString() : "-", "url", this.getUrl() != null ? this.getUrl() : "-", "hash", this.getRawHash() != null ? this.getHash() : "-", "format", this.format.length > 0 ? Arrays.stream(this.format).mapToObj(String::valueOf).collect(Collectors.joining(".")) : "-", "version", String.valueOf(this.getVersion()), "restricted", String.valueOf(this.isRestricted()), "permission", this.getPermission(), "type", this.getType().humanName(), "parent", this.getParent() != null ? this.getParent().getName() : "-", "variants", String.valueOf(this.getVariants().size())};
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("url", this.url == null || this.url.isEmpty() || !this.variants.isEmpty() ? null : this.url);
        map.put("uuid", this.uuid == null || !this.variants.isEmpty() ? null : this.uuid.toString());
        map.put("hash", this.hash == null || this.hash.length == 0 || !this.variants.isEmpty() ? null : this.getHash());
        map.put("local-path", this.localPath == null || this.localPath.isEmpty() || !this.variants.isEmpty() ? null : this.localPath);
        if (this.name.equalsIgnoreCase("empty")) {
            map.put("format", null);
            map.put("version", null);
            map.put("restricted", null);
            map.put("permission", null);
        } else {
            if (this.format.length > 0) {
                map.put("format", Arrays.stream(this.format).mapToObj(String::valueOf).collect(Collectors.joining(".")));
            } else {
                map.put("format", null);
            }
            if (this.version > 0) {
                MinecraftVersion mcVersion = MinecraftVersion.getExactVersion(this.version);
                map.put("version", mcVersion != null ? mcVersion.toConfigString() : Integer.valueOf(this.version));
            } else {
                map.put("version", null);
            }
            map.put("restricted", this.restricted);
            map.put("permission", this.permission);
            if (this.type == ClientType.ORIGINAL) {
                map.put("type", null);
            } else {
                map.put("type", this.type.name().toLowerCase(Locale.ROOT));
            }
        }
        if (this.variants.isEmpty()) {
            map.put("variants", null);
        } else {
            ArrayList<Map<String, Object>> variantsList = new ArrayList<Map<String, Object>>();
            for (ResourcePack packVariant : this.variants) {
                variantsList.add(packVariant.serialize());
            }
            map.put("variants", variantsList);
        }
        return map;
    }
}

