/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit;

import de.themoep.resourcepacksplugin.bukkit.MetricsLite;
import de.themoep.resourcepacksplugin.bukkit.UsePackCommand;
import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacksCommand;
import de.themoep.resourcepacksplugin.bukkit.events.ResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.bukkit.events.ResourcePackSendEvent;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper_fallback;
import de.themoep.resourcepacksplugin.bukkit.listeners.AuthmeLoginListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.DisconnectListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.ProxyPackListener;
import de.themoep.resourcepacksplugin.bukkit.listeners.WorldSwitchListener;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import fr.xephi.authme.api.NewAPI;
import fr.xephi.authme.events.LoginEvent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.ViaAPI;

public class WorldResourcepacks
extends JavaPlugin
implements ResourcepacksPlugin {
    private PackManager pm;
    private UserManager um;
    private Level loglevel = Level.INFO;
    private int serverPackFormat = Integer.MAX_VALUE;
    private InternalHelper internalHelper;
    private ViaAPI viaApi;
    private NewAPI authmeApi;

    public void onEnable() {
        if (this.loadConfig()) {
            Class internalClass;
            this.getServer().getPluginManager().registerEvents((Listener)new DisconnectListener(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new WorldSwitchListener(this), (Plugin)this);
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "Resourcepack");
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "Resourcepack", (PluginMessageListener)new ProxyPackListener(this));
            this.getCommand(this.getName().toLowerCase().charAt(0) + "rp").setExecutor((CommandExecutor)new WorldResourcepacksCommand(this));
            this.getCommand("usepack").setExecutor((CommandExecutor)new UsePackCommand(this));
            String versionString = this.getServer().getBukkitVersion();
            int firstPoint = versionString.indexOf(".");
            int secondPoint = versionString.indexOf(".", firstPoint + 1);
            int minus = versionString.indexOf("-", firstPoint + 1);
            String versionNumberString = versionString.substring(firstPoint + 1, secondPoint < minus && secondPoint != -1 ? secondPoint : minus);
            try {
                int serverVersion = Integer.valueOf(versionNumberString);
                this.serverPackFormat = serverVersion < 8 ? 0 : (serverVersion < 9 ? 1 : (serverVersion < 11 ? 2 : 3));
                this.getLogger().log(Level.INFO, "Detected server packformat " + this.serverPackFormat + "!");
            }
            catch (NumberFormatException e) {
                this.getLogger().log(Level.WARNING, "Could not get version of the server! (" + versionString + "/" + versionNumberString + ")");
            }
            String packageName = this.getServer().getClass().getPackage().getName();
            String serverVersion = packageName.substring(packageName.lastIndexOf(46) + 1);
            try {
                internalClass = Class.forName(this.getClass().getPackage().getName() + ".internal.InternalHelper_" + serverVersion);
            }
            catch (Exception e) {
                internalClass = InternalHelper_fallback.class;
            }
            try {
                if (InternalHelper.class.isAssignableFrom(internalClass)) {
                    this.internalHelper = (InternalHelper)internalClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                this.internalHelper = new InternalHelper_fallback();
            }
            ViaVersionPlugin viaPlugin = (ViaVersionPlugin)this.getServer().getPluginManager().getPlugin("ViaVersion");
            if (viaPlugin != null) {
                this.viaApi = viaPlugin.getApi();
                this.getLogger().log(Level.INFO, "Detected ViaVersion " + this.viaApi.getVersion());
            }
            if (this.getConfig().getBoolean("autogeneratehashes", true)) {
                this.getPackManager().generateHashes(null);
            }
            this.um = new UserManager(this);
            try {
                MetricsLite metrics = new MetricsLite((Plugin)this);
                metrics.start();
            }
            catch (IOException iOException) {}
        } else {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public boolean loadConfig() {
        List globalsecondary;
        String globalpackname;
        this.saveDefaultConfig();
        this.reloadConfig();
        this.getLogger().log(Level.INFO, "Loading config!");
        try {
            String debugString = this.getConfig().getString("debug", "true");
            if (debugString.equalsIgnoreCase("true")) {
                this.loglevel = Level.INFO;
            } else if (debugString.equalsIgnoreCase("false")) {
                this.loglevel = Level.OFF;
            } else {
                try {
                    this.loglevel = Level.parse(debugString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, "Wrong config value for debug!", e);
                }
            }
        }
        catch (ClassCastException e) {
            this.loglevel = this.getConfig().getBoolean("debug", true) ? Level.INFO : Level.OFF;
        }
        this.getLogger().log(Level.INFO, "Debug level: " + this.getLogLevel().getName());
        this.pm = new PackManager(this);
        ConfigurationSection packs = this.getConfig().getConfigurationSection("packs");
        this.getLogger().log(this.getLogLevel(), "Loading packs:");
        for (String s : packs.getKeys(false)) {
            ConfigurationSection packSection = packs.getConfigurationSection(s);
            String packName = s.toLowerCase();
            String packUrl = packSection.getString("url", "");
            if (packUrl.isEmpty()) {
                this.getLogger().log(Level.SEVERE, "Pack " + (String)packName + " does not have an url defined!");
                continue;
            }
            String packHash = packSection.getString("hash", "");
            int packFormat = packSection.getInt("format", 0);
            boolean packRestricted = packSection.getBoolean("restricted", false);
            String packPerm = packSection.getString("permission", this.getName().toLowerCase() + ".pack." + (String)packName);
            ResourcePack pack = new ResourcePack(packName, packUrl, packHash, packFormat, packRestricted, packPerm);
            this.getLogger().log(this.getLogLevel(), pack.getName() + " - " + pack.getUrl() + " - " + pack.getHash());
            try {
                this.getPackManager().addPack(pack);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage());
                continue;
            }
            if (this.getServer().getPluginManager().getPermission(packPerm) != null) continue;
            Permission perm = new Permission(packPerm);
            perm.setDefault(PermissionDefault.OP);
            perm.setDescription("Permission for access to the resourcepack " + pack.getName() + " via the usepack command.");
            this.getServer().getPluginManager().addPermission(perm);
        }
        String emptypackname = this.getConfig().getString("empty", null);
        if (emptypackname != null && !emptypackname.isEmpty()) {
            ResourcePack ep = this.getPackManager().getByName(emptypackname);
            if (ep != null) {
                this.getLogger().log(this.getLogLevel(), "Empty pack: " + ep.getName());
                this.getPackManager().setEmptyPack(ep);
            } else {
                this.getLogger().warning("Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
            }
        }
        if (!(globalpackname = this.getConfig().getString("server.pack", "")).isEmpty()) {
            ResourcePack gp = this.getPackManager().getByName(globalpackname);
            if (gp != null) {
                this.getLogger().log(this.getLogLevel(), "Server pack: " + gp.getName() + "!");
                this.getPackManager().setGlobalPack(gp);
            } else {
                this.getLogger().warning("Cannot set server resourcepack as there is no pack with the name " + globalpackname + " defined!");
            }
        }
        if ((globalsecondary = this.getConfig().getStringList("server.secondary")) != null && globalsecondary.size() > 0) {
            this.getLogger().log(this.getLogLevel(), "Server secondary packs:");
            for (String secondarypack : globalsecondary) {
                ResourcePack sp = this.getPackManager().getByName(secondarypack);
                if (sp != null) {
                    this.getPackManager().addGlobalSecondary(sp);
                    this.getLogger().log(this.getLogLevel(), sp.getName());
                    continue;
                }
                this.getLogger().warning("Cannot add resourcepack as a server secondary pack as there is no pack with the name " + secondarypack + " defined!");
            }
        }
        ConfigurationSection servers = this.getConfig().getConfigurationSection("worlds");
        for (String s : servers.getKeys(false)) {
            List serversecondary;
            this.getLogger().log(this.getLogLevel(), "Loading settings for world " + s + "!");
            String packname = servers.getString(s + ".pack", "");
            if (!packname.isEmpty()) {
                ResourcePack sp = this.getPackManager().getByName(packname);
                if (sp != null) {
                    this.getPackManager().addServer(s, sp);
                    this.getLogger().log(this.getLogLevel(), "Pack: " + sp.getName() + "!");
                } else {
                    this.getLogger().warning("Cannot set resourcepack for " + s + " as there is no pack with the name " + packname + " defined!");
                }
            } else {
                this.getLogger().log(this.getLogLevel(), "No pack setting for " + s + "!");
            }
            if ((serversecondary = servers.getStringList(s + ".secondary")) == null || serversecondary.size() <= 0) continue;
            this.getLogger().log(this.getLogLevel(), "Secondary packs:");
            for (String secondarypack : serversecondary) {
                ResourcePack sp = this.getPackManager().getByName(secondarypack);
                if (sp != null) {
                    this.getPackManager().addServerSecondary(s, sp);
                    this.getLogger().log(this.getLogLevel(), sp.getName());
                    continue;
                }
                this.getLogger().warning("Cannot add resourcepack as a secondary pack for world " + s + " as there is no pack with the name " + secondarypack + " defined!");
            }
        }
        if (this.getConfig().getBoolean("useauthme", true) && this.getServer().getPluginManager().getPlugin("AuthMe") != null) {
            this.authmeApi = NewAPI.getInstance();
            this.getLogger().log(Level.INFO, "Detected AuthMe " + this.getServer().getPluginManager().getPlugin("AuthMe").getDescription().getVersion());
            LoginEvent.getHandlerList().unregister((Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new AuthmeLoginListener(this), (Plugin)this);
        }
        return true;
    }

    @Override
    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.getLogger().log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.getLogger().log(Level.INFO, "Resending packs for all online players!");
            this.um = new UserManager(this);
            for (Player p : this.getServer().getOnlinePlayers()) {
                this.resendPack(p);
            }
        }
    }

    @Override
    public void saveConfigChanges() {
        for (ResourcePack pack : this.getPackManager().getPacks()) {
            String path = "packs." + pack.getName();
            this.getConfig().set(path + ".url", (Object)pack.getUrl());
            this.getConfig().set(path + ".hash", (Object)pack.getHash());
            this.getConfig().set(path + ".format", (Object)pack.getFormat());
            this.getConfig().set(path + ".restricted", (Object)pack.isRestricted());
            this.getConfig().set(path + ".permission", (Object)pack.getPermission());
        }
        this.saveConfig();
    }

    @Override
    public void resendPack(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.resendPack(player);
        }
    }

    public void resendPack(Player player) {
        String worldName = "";
        if (player.getWorld() != null) {
            worldName = player.getWorld().getName();
        }
        this.getPackManager().applyPack(player.getUniqueId(), worldName);
    }

    @Override
    public void setPack(UUID playerId, ResourcePack pack) {
        this.getPackManager().setPack(playerId, pack);
    }

    @Override
    public void sendPack(UUID playerId, ResourcePack pack) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.sendPack(player, pack);
        }
    }

    public void sendPack(Player player, ResourcePack pack) {
        if (!pack.getHash().isEmpty()) {
            this.internalHelper.setResourcePack(player, pack.getUrl(), pack.getHash());
        } else {
            player.setResourcePack(pack.getUrl());
        }
        this.getLogger().log(this.getLogLevel(), "Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
    }

    @Override
    public void clearPack(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            this.clearPack(player);
        }
    }

    public void clearPack(Player player) {
        this.getUserManager().clearUserPack(player.getUniqueId());
    }

    @Override
    public PackManager getPackManager() {
        return this.pm;
    }

    @Override
    public UserManager getUserManager() {
        return this.um;
    }

    @Override
    public String getMessage(String key) {
        String msg = this.getConfig().getString("messages." + key);
        if (msg == null || msg.isEmpty()) {
            msg = "&cUnknown message key: &6messages." + key;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    @Override
    public String getMessage(String key, Map<String, String> replacements) {
        String msg = this.getMessage(key);
        if (replacements != null) {
            for (Map.Entry<String, String> repl : replacements.entrySet()) {
                msg = msg.replace("%" + repl.getKey() + "%", repl.getValue());
            }
        }
        return msg;
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public Level getLogLevel() {
        return this.loglevel;
    }

    @Override
    public ResourcepacksPlayer getPlayer(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            return new ResourcepacksPlayer(player.getName(), player.getUniqueId());
        }
        return null;
    }

    @Override
    public ResourcepacksPlayer getPlayer(String playerName) {
        Player player = this.getServer().getPlayer(playerName);
        if (player != null) {
            return new ResourcepacksPlayer(player.getName(), player.getUniqueId());
        }
        return null;
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, String message) {
        return this.sendMessage(player, Level.INFO, message);
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer packPlayer, Level level, String message) {
        if (packPlayer != null) {
            Player player = this.getServer().getPlayer(packPlayer.getUniqueId());
            if (player != null) {
                player.sendMessage(message);
                return true;
            }
        } else {
            this.getLogger().log(level, message);
        }
        return false;
    }

    @Override
    public boolean checkPermission(ResourcepacksPlayer player, String perm) {
        if (player == null) {
            return true;
        }
        return this.checkPermission(player.getUniqueId(), perm);
    }

    @Override
    public boolean checkPermission(UUID playerId, String perm) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            return player.hasPermission(perm);
        }
        return false;
    }

    @Override
    public int getPlayerPackFormat(UUID playerId) {
        Player player = this.getServer().getPlayer(playerId);
        if (player != null) {
            if (this.viaApi != null) {
                return this.getPackManager().getPackFormat(this.viaApi.getPlayerVersion(playerId));
            }
            return this.serverPackFormat;
        }
        return -1;
    }

    @Override
    public IResourcePackSelectEvent callPackSelectEvent(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        ResourcePackSelectEvent selectEvent = new ResourcePackSelectEvent(playerId, pack, status);
        this.getServer().getPluginManager().callEvent((Event)selectEvent);
        return selectEvent;
    }

    @Override
    public IResourcePackSendEvent callPackSendEvent(UUID playerId, ResourcePack pack) {
        ResourcePackSendEvent sendEvent = new ResourcePackSendEvent(playerId, pack);
        this.getServer().getPluginManager().callEvent((Event)sendEvent);
        return sendEvent;
    }

    @Override
    public boolean isAuthenticated(UUID playerId) {
        if (this.authmeApi == null) {
            return true;
        }
        Player player = this.getServer().getPlayer(playerId);
        return player != null && this.authmeApi.isAuthenticated(player);
    }

    @Override
    public int runAsync(Runnable runnable) {
        return this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable).getTaskId();
    }
}

