/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit.listeners;

import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacks;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WorldSwitchListener
implements Listener {
    WorldResourcepacks plugin;

    public WorldSwitchListener(WorldResourcepacks plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        this.calculatePack(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final UUID playerId = event.getPlayer().getUniqueId();
        new BukkitRunnable(){

            public void run() {
                WorldSwitchListener.this.calculatePack(playerId);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
    }

    private void calculatePack(UUID playerId) {
        Player player;
        if (this.plugin.isEnabled() && this.plugin.isAuthenticated(playerId) && (player = this.plugin.getServer().getPlayer(playerId)) != null) {
            String worldName = "";
            if (player.getWorld() != null) {
                worldName = player.getWorld().getName();
            }
            this.plugin.getPackManager().applyPack(player.getUniqueId(), worldName);
        }
    }
}

