/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.libs.lang;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LanguageConfig<C> {
    private static final Map<String, Pattern> PATTERN_CACHE = new HashMap<String, Pattern>();
    private final String locale;
    protected final String resourcePath;
    protected final File configFile;
    protected final boolean saveFile;
    private String placeholderPrefix = "%";
    private String placeholderSuffix = "%";
    protected C config;
    protected C defaultConfig;

    protected LanguageConfig(String resourceFolder, File configFile, String locale) {
        this(resourceFolder, configFile, locale, true);
    }

    protected LanguageConfig(String resourceFolder, File configFile, String locale, boolean saveFile) {
        this.locale = locale;
        this.configFile = configFile;
        this.saveFile = saveFile;
        this.resourcePath = resourceFolder.isEmpty() ? configFile.getName() : resourceFolder + "/" + configFile.getName();
    }

    public abstract void loadConfig();

    public abstract boolean saveConfigResource();

    public abstract boolean contains(String var1);

    public abstract boolean contains(String var1, boolean var2);

    public abstract String get(String var1);

    public abstract C getRawConfig();

    public String get(String key, String ... replacements) {
        return this.replace(this.get(key), replacements);
    }

    public String get(String key, Map<String, String> replacements) {
        String[] replacementArray = new String[replacements.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            replacementArray[i] = entry.getKey();
            replacementArray[++i] = entry.getValue();
            ++i;
        }
        return this.replace(this.get(key), replacementArray);
    }

    private String replace(String string, String ... replacements) {
        int i = 0;
        while (i + 1 < replacements.length) {
            if (replacements[i] != null) {
                String placeholder = this.placeholderPrefix + replacements[i] + this.placeholderSuffix;
                Pattern pattern = PATTERN_CACHE.get(placeholder);
                if (pattern == null) {
                    pattern = Pattern.compile(placeholder, 16);
                    PATTERN_CACHE.put(placeholder, pattern);
                }
                string = pattern.matcher(string).replaceAll(Matcher.quoteReplacement(replacements[i + 1] != null ? replacements[i + 1] : "null"));
            }
            i += 2;
        }
        return string;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setDefaults(LanguageConfig<? extends C> defaults) {
        this.defaultConfig = defaults == null ? null : defaults.getRawConfig();
    }

    void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }
}

