/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.ShowItem.api.data;

import de.themoep.ShowItem.api.data.EnderData;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StaticEnderData
implements EnderData {
    private final UUID playerId;
    private final String playerName;
    private final ItemStack[] storageContents;

    public StaticEnderData(Player player) {
        ItemStack[] contents;
        this.playerId = player.getUniqueId();
        this.playerName = player.getName();
        try {
            contents = player.getEnderChest().getStorageContents();
        }
        catch (NoSuchMethodError e) {
            contents = player.getEnderChest().getContents();
        }
        this.storageContents = (ItemStack[])Arrays.stream(contents).map(this::copy).toArray(ItemStack[]::new);
    }

    private ItemStack copy(ItemStack itemStack) {
        return itemStack != null ? new ItemStack(itemStack) : null;
    }

    @Override
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.storageContents;
    }
}

