/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils;

import de.themoep.utils.BitUtils;
import de.themoep.utils.ColorUtils;
import de.themoep.utils.ConfigAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.material.SpawnEgg;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public class IconRpMapping {
    private Map<String, Integer> encodingNames = new HashMap<String, Integer>();
    private final String[] potionids = new String[]{"unused", "regen", "speed", "fire_resistance", "poison", "instant_heal", "night_vision", "unused", "weakness", "strength", "slowness", "jump", "instant_damage", "water_breathing", "invisibility"};
    private int offset;
    private boolean legacy = true;

    public IconRpMapping(JavaPlugin plugin) {
        plugin.getLogger().info("Loading Text Icon Resourcepack mapping...");
        String fileName = "iconrpmapping.yml";
        try {
            String apiVersion = plugin.getDescription().getAPIVersion();
            plugin.getLogger().info("Found API-Version " + apiVersion + ", using new Material IDs...");
            fileName = "iconrpmapping-flattening.yml";
            this.legacy = false;
        }
        catch (NoSuchMethodError e) {
            plugin.getLogger().info("Using pre 1.13 API and legacy Material IDs...");
        }
        ConfigAccessor iconconfig = new ConfigAccessor((Plugin)plugin, fileName);
        iconconfig.saveDefaultConfig();
        iconconfig.reloadConfig();
        this.offset = iconconfig.getConfig().getInt("offset");
        List matlist = iconconfig.getConfig().getStringList("map");
        for (int i = 0; i < matlist.size(); ++i) {
            String name = ((String)matlist.get(i)).toLowerCase();
            this.encodingNames.put(name, i);
        }
        plugin.getLogger().info("Text Icon Resourcepack mapping loaded.");
    }

    public String getIcon(ItemStack item) {
        return this.getIcon(item, false);
    }

    public String getIcon(ItemStack item, boolean escape) {
        ItemMeta meta = item.getItemMeta();
        String iconstr = null;
        if (meta instanceof LeatherArmorMeta) {
            iconstr = ColorUtils.getNearestChatColor(((LeatherArmorMeta)meta).getColor()) + this.getIcon("white_" + item.getType().toString(), false) + ChatColor.RESET;
        } else if (meta instanceof PotionMeta) {
            block34: {
                PotionMeta pm = (PotionMeta)meta;
                try {
                    iconstr = this.getIcon(item.getType().toString() + "_" + pm.getBasePotionData().getType().toString(), escape);
                }
                catch (NoSuchMethodError e) {
                    if (!pm.hasCustomEffects()) break block34;
                    iconstr = this.getIcon(item.getType().toString() + "_" + ((PotionEffect)pm.getCustomEffects().get(0)).getType().toString(), escape);
                }
            }
            if (iconstr == null) {
                iconstr = this.getIcon(item.getType().toString() + "_water", escape);
            }
        } else if (item.getType() == Material.POTION) {
            String key = "water_potion";
            if (item.getDurability() == 0) {
                iconstr = this.getIcon(key, escape);
            } else {
                String splash = "";
                boolean[] bits = BitUtils.getBits(item.getDurability());
                int id = BitUtils.getRange(item.getDurability(), 0, 3);
                if (id < this.potionids.length) {
                    key = this.potionids[id].toLowerCase();
                }
                if (bits[1]) {
                    splash = "splash_";
                }
                if ((iconstr = this.getIcon(key + "_" + splash + "potion", true)) == null) {
                    iconstr = this.getIcon(splash + key + "_potion", true);
                }
            }
        } else if (meta instanceof FireworkEffectMeta) {
            FireworkEffect fe = ((FireworkEffectMeta)meta).getEffect();
            if (fe != null && !fe.getColors().isEmpty()) {
                Color median = ((Color)fe.getColors().get(0)).mixColors((Color[])fe.getColors().stream().skip(1L).toArray());
                iconstr = this.getIcon(item.getType().toString() + "_" + ColorUtils.getNearestChatColor(median).name(), escape);
            }
        } else if ((this.legacy || item.getType() == Material.SHIELD) && meta instanceof BannerMeta) {
            BannerMeta bm = (BannerMeta)meta;
            iconstr = this.getIcon(item.getType().toString() + "_" + bm.getBaseColor(), escape);
            if (iconstr == null) {
                iconstr = this.getIcon(item.getType() + "_" + DyeColor.getByDyeData((byte)item.getData().getData()), escape);
            }
        } else if (this.legacy && meta instanceof BlockStateMeta && ((BlockStateMeta)meta).getBlockState() instanceof Banner) {
            Banner banner = (Banner)((BlockStateMeta)meta).getBlockState();
            iconstr = this.getIcon(item.getType().toString() + "_" + banner.getBaseColor(), escape);
        } else if (this.legacy && item.getData() instanceof SpawnEgg) {
            SpawnEgg spawnEgg = (SpawnEgg)item.getData();
            if (spawnEgg.getSpawnedType() != null && (iconstr = this.getIcon(item.getType().toString() + "_" + spawnEgg.getSpawnedType(), escape)) == null) {
                iconstr = this.getIcon(item.getType().toString() + ":" + spawnEgg.getSpawnedType().getTypeId(), escape);
            }
            if (iconstr == null) {
                iconstr = this.getIcon(item.getType().toString() + ":" + spawnEgg.getData(), escape);
            }
        }
        boolean isUnbreakable = false;
        if (iconstr == null) {
            try {
                isUnbreakable = item.getItemMeta().isUnbreakable();
            }
            catch (NoSuchMethodError e) {
                try {
                    isUnbreakable = item.getItemMeta().spigot().isUnbreakable();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            if (isUnbreakable) {
                iconstr = this.getIcon(item.getType().toString() + ":unbreakable:" + item.getDurability(), escape);
            }
        }
        if (iconstr == null) {
            iconstr = this.getIcon(item.getType().toString() + ":" + item.getDurability(), escape);
        }
        if (iconstr == null && isUnbreakable) {
            iconstr = this.getIcon(item.getType().toString() + ":unbreakable", escape);
        }
        if (iconstr == null) {
            iconstr = this.getIcon(item.getType().toString(), escape);
        }
        return iconstr != null ? iconstr : "";
    }

    public String getIcon(String iconname, boolean escape) {
        if (this.encodingNames.containsKey(iconname.toLowerCase())) {
            String symbol = Character.toString((char)(this.offset + this.encodingNames.get(iconname.toLowerCase())));
            if (escape) {
                symbol = ChatColor.WHITE + symbol + ChatColor.RESET;
            }
            return symbol;
        }
        return null;
    }

    public boolean isLegacy() {
        return this.legacy;
    }
}

