/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.ShowItem.api.data;

import de.themoep.ShowItem.api.data.InvData;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StaticInvData
implements InvData {
    private final UUID playerId;
    private final String playerName;
    private final ItemStack helmet;
    private final ItemStack chestplate;
    private final ItemStack leggings;
    private final ItemStack boots;
    private final ItemStack itemInOffhand;
    private final ItemStack[] storageContents;

    public StaticInvData(Player player) {
        ItemStack[] contents;
        this.playerId = player.getUniqueId();
        this.playerName = player.getName();
        this.helmet = this.copy(player.getInventory().getHelmet());
        this.chestplate = this.copy(player.getInventory().getChestplate());
        this.leggings = this.copy(player.getInventory().getLeggings());
        this.boots = this.copy(player.getInventory().getBoots());
        ItemStack itemInOffHand = null;
        try {
            itemInOffHand = player.getInventory().getItemInOffHand();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.itemInOffhand = this.copy(itemInOffHand);
        try {
            contents = player.getInventory().getStorageContents();
        }
        catch (NoSuchMethodError e) {
            contents = player.getInventory().getContents();
        }
        this.storageContents = (ItemStack[])Arrays.stream(contents).map(this::copy).toArray(ItemStack[]::new);
    }

    private ItemStack copy(ItemStack itemStack) {
        return itemStack != null ? new ItemStack(itemStack) : null;
    }

    @Override
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public ItemStack getHelmet() {
        return this.helmet;
    }

    @Override
    public ItemStack getChestplate() {
        return this.chestplate;
    }

    @Override
    public ItemStack getLeggings() {
        return this.leggings;
    }

    @Override
    public ItemStack getBoots() {
        return this.boots;
    }

    @Override
    public ItemStack getItemInOffHand() {
        return this.itemInOffhand;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.storageContents;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

