/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemMatcher {
    private final MatchDefinition defaultMatcher;
    private final List<MatchDefinition> specificDefinitions = new ArrayList<MatchDefinition>();

    public ItemMatcher(JavaPlugin plugin, ConfigurationSection config) throws IllegalArgumentException {
        this.defaultMatcher = new MatchDefinition(plugin, config);
        for (String specificKey : config.getConfigurationSection("specific").getKeys(false)) {
            this.specificDefinitions.add(new MatchDefinition(plugin, specificKey, config.getConfigurationSection("specific." + specificKey)));
        }
    }

    public MatchDefinition getMatching(ItemStack item) {
        for (MatchDefinition definition : this.specificDefinitions) {
            if (!definition.matches(item)) continue;
            return definition;
        }
        if (this.defaultMatcher.matches(item)) {
            return this.defaultMatcher;
        }
        return null;
    }

    public static class MatchDefinition {
        private final String name;
        private boolean isDefault = false;
        private final boolean inverted;
        private final Set<Material> materials = EnumSet.noneOf(Material.class);
        private final Set<Pattern> names = new LinkedHashSet<Pattern>();
        private final Set<Pattern> lores = new LinkedHashSet<Pattern>();
        private final List<NumberComparator> durability = new ArrayList<NumberComparator>();
        private final Boolean unbreakable;
        private final Map<Enchantment, List<NumberComparator>> enchantments = new HashMap<Enchantment, List<NumberComparator>>();
        private final Pattern serializedRegex;

        public MatchDefinition(JavaPlugin plugin, ConfigurationSection config) {
            this(plugin, "default", config);
            this.isDefault = true;
        }

        public MatchDefinition(JavaPlugin plugin, String name, ConfigurationSection config) {
            this.name = name;
            this.inverted = config.getBoolean("inverted");
            for (String matStr : config.getStringList("material")) {
                Material mat = Material.getMaterial((String)matStr);
                if (mat != null) {
                    this.materials.add(mat);
                    continue;
                }
                plugin.getLogger().log(Level.WARNING, matStr + " is not a valid material name!");
            }
            for (String nameStr : config.getStringList("name")) {
                try {
                    if (nameStr.startsWith("r=")) {
                        this.names.add(Pattern.compile("(?i)" + nameStr.substring(2)));
                        continue;
                    }
                    this.names.add(Pattern.compile("(?i)" + Pattern.quote(nameStr)));
                }
                catch (PatternSyntaxException e) {
                    plugin.getLogger().log(Level.WARNING, nameStr + " is not a valid name pattern!");
                }
            }
            for (String lore : config.getStringList("lore")) {
                try {
                    if (lore.startsWith("r=")) {
                        this.lores.add(Pattern.compile("(?i)" + lore.substring(2)));
                        continue;
                    }
                    this.lores.add(Pattern.compile("(?i)" + Pattern.quote(lore)));
                }
                catch (PatternSyntaxException e) {
                    plugin.getLogger().log(Level.WARNING, lore + " is not a valid lore pattern!");
                }
            }
            if (config.contains("durability")) {
                for (String def : config.getString("durability").split(",")) {
                    try {
                        this.durability.add(new NumberComparator(def));
                    }
                    catch (IllegalArgumentException e) {
                        plugin.getLogger().log(Level.WARNING, (String)def + " is not a valid durability comparator string!");
                    }
                }
            }
            this.unbreakable = config.contains("unbreakable") ? Boolean.valueOf(config.getBoolean("unbreakable")) : null;
            for (String enchStr : config.getStringList("enchantments")) {
                Enchantment ench;
                String[] enchStrParts;
                String levelStr = "";
                if (enchStr.contains(":") && (enchStrParts = enchStr.split(":")).length > 1) {
                    enchStr = enchStrParts[0];
                    levelStr = enchStrParts[1];
                }
                if ((ench = Enchantment.getByName((String)enchStr.toUpperCase())) != null) {
                    ArrayList<NumberComparator> comparators = new ArrayList<NumberComparator>();
                    for (String def : levelStr.split(",")) {
                        try {
                            comparators.add(new NumberComparator(def));
                        }
                        catch (IllegalArgumentException e) {
                            plugin.getLogger().log(Level.WARNING, def + " is not a valid level comparator string!");
                        }
                    }
                    this.enchantments.put(ench, comparators);
                    continue;
                }
                plugin.getLogger().log(Level.WARNING, enchStr + " is not a valid Enchantment name!");
            }
            String serializedStr = config.getString("serialized");
            Pattern serializedPattern = null;
            if (serializedStr != null && !serializedStr.isEmpty()) {
                try {
                    serializedPattern = Pattern.compile(serializedStr);
                }
                catch (PatternSyntaxException e) {
                    plugin.getLogger().log(Level.WARNING, serializedStr + " is not a valid serialized regex string! " + e.getMessage());
                }
            }
            this.serializedRegex = serializedPattern;
        }

        public boolean matches(ItemStack item) {
            BlockState blockState;
            if (item == null) {
                return false;
            }
            boolean matches = !this.inverted;
            boolean doesNotMatch = this.inverted;
            if (item.hasItemMeta() && item.getItemMeta() instanceof BlockStateMeta && (blockState = ((BlockStateMeta)item.getItemMeta()).getBlockState()) instanceof Container) {
                for (ItemStack itemStack : ((Container)blockState).getInventory()) {
                    if (!this.matches(itemStack)) continue;
                    return matches;
                }
            }
            if (!this.materials.contains(item.getType())) {
                return doesNotMatch;
            }
            if (!this.comparatorsMatch(this.durability, item.getDurability())) {
                return doesNotMatch;
            }
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                if (this.unbreakable != null && this.unbreakable.booleanValue() != meta.isUnbreakable()) {
                    return doesNotMatch;
                }
                if (!this.enchantmentsMatch(item.getEnchantments())) {
                    return doesNotMatch;
                }
                if (meta instanceof EnchantmentStorageMeta && !this.enchantmentsMatch(((EnchantmentStorageMeta)meta).getStoredEnchants())) {
                    return doesNotMatch;
                }
                if (meta.hasDisplayName() && !this.patternsMatch(this.names, meta.getDisplayName())) {
                    return doesNotMatch;
                }
                if (meta.hasLore() && !this.patternsMatch(this.names, String.join((CharSequence)"\n", meta.getLore()))) {
                    return doesNotMatch;
                }
            } else if (this.unbreakable != null || !this.enchantments.isEmpty() || !this.names.isEmpty()) {
                return doesNotMatch;
            }
            if (this.serializedRegex != null) {
                YamlConfiguration yaml = new YamlConfiguration();
                yaml.set("item", (Object)item);
                String yamlStr = yaml.saveToString();
                if (!this.serializedRegex.matcher(yamlStr).find()) {
                    return doesNotMatch;
                }
            }
            return matches;
        }

        private boolean comparatorsMatch(List<NumberComparator> comparators, int i) {
            for (NumberComparator comparator : comparators) {
                if (comparator.matches(i)) continue;
                return false;
            }
            return true;
        }

        private boolean patternsMatch(Collection<Pattern> patterns, String toMatch) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(toMatch).find()) continue;
                return true;
            }
            return false;
        }

        private boolean enchantmentsMatch(Map<Enchantment, Integer> enchantments) {
            if (this.enchantments.isEmpty()) {
                return true;
            }
            for (Map.Entry<Enchantment, Integer> ench : enchantments.entrySet()) {
                if (!this.enchantments.containsKey(ench.getKey()) || !this.comparatorsMatch(this.enchantments.get(ench.getKey()), ench.getValue())) continue;
                return true;
            }
            return false;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getName() {
            return this.name;
        }

        public static class NumberComparator {
            private final Type type;
            private final int number;

            public NumberComparator(String def) {
                if (def == null || def.isEmpty() || "*".equals(def)) {
                    this.type = Type.ANY;
                    this.number = -1;
                    return;
                }
                for (Type t : Type.values()) {
                    if (!def.startsWith(t.symbol())) continue;
                    this.type = t;
                    try {
                        this.number = Integer.parseInt(def.substring(t.symbol().length()));
                    }
                    catch (NumberFormatException ignored) {
                        throw new IllegalArgumentException(def + " is not a valid NumberComparator definition!");
                    }
                    return;
                }
                this.type = Type.EQUALS;
                try {
                    this.number = Integer.parseInt(def);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(def + " is not a valid NumberComparator definition!");
                }
            }

            public boolean matches(int i) {
                switch (this.type) {
                    case ANY: {
                        return true;
                    }
                    case EQUALS: {
                        return i == this.number;
                    }
                    case NOT_EQUALS: {
                        return i != this.number;
                    }
                    case LESS_THAN: {
                        return i < this.number;
                    }
                    case GREATHER_THAN: {
                        return i > this.number;
                    }
                }
                return false;
            }

            public static enum Type {
                ANY("*"),
                GREATHER_THAN(">"),
                LESS_THAN("<"),
                EQUALS("="),
                NOT_EQUALS("!=");

                private final String symbol;

                private Type(String symbol) {
                    this.symbol = symbol;
                }

                public String symbol() {
                    return this.symbol;
                }
            }
        }
    }
}

