/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.utils;

import de.themoep.utils.ConfigAccessor;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public class TranslationMapping {
    private Map<String, String> transmap = new HashMap<String, String>();
    private ConfigAccessor langconfig;
    private boolean legacy = true;

    public TranslationMapping(JavaPlugin plugin) {
        plugin.getLogger().info("Loading TranslationMapping...");
        try {
            String apiVersion = plugin.getDescription().getAPIVersion();
            plugin.getLogger().info("Found API-Version " + apiVersion + ", using new Material IDs...");
            this.legacy = false;
        }
        catch (NoSuchMethodError e) {
            plugin.getLogger().info("Using pre 1.13 API and legacy Material IDs...");
        }
        if (this.legacy) {
            this.langconfig = new ConfigAccessor((Plugin)plugin, "transmapping.yml");
            this.langconfig.saveDefaultConfig();
            this.langconfig.reloadConfig();
            ConfigurationSection blocksection = this.langconfig.getConfig().getConfigurationSection("mapping");
            for (String matname : blocksection.getKeys(false)) {
                try {
                    String matkey = matname.toUpperCase();
                    Material.valueOf((String)matkey);
                    if (blocksection.isConfigurationSection(matname)) {
                        ConfigurationSection damagesection;
                        String mckey;
                        String template;
                        ConfigurationSection extrasection = blocksection.getConfigurationSection(matname);
                        String general = extrasection.getString("general");
                        if (general != null) {
                            this.transmap.put(matkey, general);
                        }
                        if ((template = extrasection.getString("template")) != null) {
                            ConfigurationSection templatesection = this.langconfig.getConfig().getConfigurationSection("templates." + template);
                            if (templatesection != null) {
                                for (String damage : templatesection.getKeys(false)) {
                                    mckey = templatesection.getString(damage);
                                    if (general != null) {
                                        mckey = general + "." + mckey;
                                    }
                                    this.transmap.put(matkey + ":" + damage, mckey);
                                }
                            } else {
                                plugin.getLogger().warning("[TranslationMapping] The template " + template + " does not exist!");
                            }
                        }
                        if ((damagesection = extrasection.getConfigurationSection("types")) == null) continue;
                        for (String damage : damagesection.getKeys(false)) {
                            mckey = damagesection.getString(damage);
                            if (general != null) {
                                mckey = general + "." + mckey;
                            }
                            this.transmap.put(matkey + ":" + damage, mckey);
                        }
                        continue;
                    }
                    this.transmap.put(matkey, blocksection.getString(matname));
                }
                catch (IllegalArgumentException e) {
                    plugin.getLogger().warning("[TranslationMapping] " + matname + " is not a valid Bukkit material name!");
                }
            }
        }
        plugin.getLogger().info("TranslationMapping loaded.");
    }

    public String getKey(ItemStack item) {
        Material mat = item.getType();
        if (item.getItemMeta() instanceof SkullMeta && ((SkullMeta)item.getItemMeta()).getOwner() != null) {
            return "item.skull.player.name";
        }
        String trans = "";
        if (this.legacy) {
            BannerMeta bm;
            DyeColor baseColor;
            short data = item.getDurability();
            if (item.hasItemMeta() && item.getItemMeta() instanceof BannerMeta && (baseColor = (bm = (BannerMeta)item.getItemMeta()).getBaseColor()) != null) {
                data = baseColor.getDyeData();
            }
            if (item.hasItemMeta() && item.getItemMeta() instanceof PotionMeta) {
                PotionMeta pm = (PotionMeta)item.getItemMeta();
                String effectName = "EMPTY";
                try {
                    effectName = pm.getBasePotionData().getType().toString();
                }
                catch (NoSuchMethodError e) {
                    if (!pm.getCustomEffects().isEmpty()) {
                        effectName = ((PotionEffect)pm.getCustomEffects().get(0)).getType().toString();
                    }
                    return "item.potion.name";
                }
                if (this.transmap.containsKey(mat.toString() + ":" + effectName)) {
                    return this.transmap.get(mat.toString() + ":" + effectName);
                }
                if (this.transmap.containsKey(mat.toString())) {
                    return this.transmap.get(mat.toString()) + "." + effectName.toLowerCase();
                }
            } else {
                trans = mat.toString().equals("POTION") ? "item.potion" : (this.transmap.containsKey(mat.toString() + ":" + data) ? this.transmap.get(mat.toString() + ":" + data) : (this.transmap.containsKey(mat.toString()) ? this.transmap.get(mat.toString()) : mat.toString().toLowerCase().replace("_block", "").replace("_item", "").replace("_", "")));
            }
            if (!trans.startsWith("item.") && !trans.startsWith("tile.")) {
                trans = (mat.isBlock() ? "tile." : "item.") + trans;
            }
            trans = trans + ".name";
        } else {
            trans = mat.toString().toLowerCase();
            if (!trans.startsWith("item.") && !trans.startsWith("block.")) {
                trans = (mat.isBlock() ? "block" : "item") + ".minecraft." + trans;
            }
        }
        return trans;
    }

    public boolean isLegacy() {
        return this.legacy;
    }
}

