/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.ShowItem.api.data;

import de.themoep.ShowItem.api.data.EnderData;
import de.themoep.ShowItem.api.data.LiveData;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class LiveEnderData
implements LiveData,
EnderData {
    private final UUID playerId;
    private String playerName;
    private WeakReference<Player> playerReference;
    private Set<UUID> viewers = new HashSet<UUID>();

    public LiveEnderData(Player player) {
        this.playerId = player.getUniqueId();
        this.playerName = player.getName();
        this.playerReference = new WeakReference<Player>(player);
    }

    @Override
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public ItemStack[] getStorageContents() {
        if (this.isValid()) {
            try {
                return ((Player)this.playerReference.get()).getEnderChest().getStorageContents();
            }
            catch (NoSuchMethodError e) {
                return ((Player)this.playerReference.get()).getEnderChest().getContents();
            }
        }
        return new ItemStack[InventoryType.ENDER_CHEST.getDefaultSize()];
    }

    @Override
    public boolean isValid() {
        if (this.playerReference.get() == null) {
            Player player = Bukkit.getPlayer((UUID)this.playerId);
            if (player == null) {
                return false;
            }
            this.playerReference = new WeakReference<Player>(player);
            this.playerName = player.getName();
        }
        return true;
    }

    @Override
    public Set<UUID> getViewers() {
        return this.viewers;
    }
}

