/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.simpleteamchat;

import de.themoep.servertags.bukkit.ServerInfo;
import de.themoep.servertags.bukkit.ServerTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Team;

public class SimpleTeamChat
extends JavaPlugin
implements CommandExecutor,
Listener {
    private ServerTags serverTags = null;
    private Chat chat = null;
    private Map<UUID, ChatDestination> playerChannels = new HashMap<UUID, ChatDestination>();
    private String globalChannel = "G";
    private String globalColor = ChatColor.GRAY + "";
    private String globalFormat = "%prefix%&f%username%%suffix%%serverinfo%&f: &7%msg%";
    private String serverInfoFormat = " &7(%tag%)";
    private String channelTagFormat = "%color%%tag% | ";
    private String teamFormat = "%tag%%prefix%&f%username%%suffix%%serverinfo%&f: &7%msg%";

    public void onEnable() {
        this.loadConfig();
        this.serverTags = (ServerTags)this.getServer().getPluginManager().getPlugin("ServerTags");
        this.setupVaultChat();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void setupVaultChat() {
        RegisteredServiceProvider crp = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (crp != null) {
            this.chat = (Chat)crp.getProvider();
        }
    }

    @EventHandler
    public void onServiceRegister(ServiceRegisterEvent event) {
        if (Chat.class.isAssignableFrom(event.getProvider().getService())) {
            this.setupVaultChat();
        }
    }

    @EventHandler
    public void onServiceUnregister(ServiceUnregisterEvent event) {
        if (Chat.class.isAssignableFrom(event.getProvider().getService())) {
            this.setupVaultChat();
        }
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.globalChannel = this.getConfig().getString("globalchannel", this.globalChannel);
        try {
            this.globalColor = ChatColor.valueOf((String)this.getConfig().getString("globalcolor").toUpperCase()) + "";
        }
        catch (IllegalArgumentException e) {
            String configColorString = this.getConfig().getString("globalcolor");
            this.globalColor = configColorString.length() == 1 ? ChatColor.getByChar((char)this.getConfig().getString("globalcolor").charAt(0)) + "" : ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("globalcolor"));
        }
        this.globalFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("globalformat", this.globalFormat));
        this.globalFormat = this.globalFormat.replace("%username%", "%s").replace("%msg%", "%s");
        this.teamFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("teamformat", this.teamFormat));
        this.teamFormat = this.teamFormat.replace("%username%", "%s").replace("%msg%", "%s");
        this.serverInfoFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("serverinfo", this.serverInfoFormat));
        this.channelTagFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("channeltag", this.channelTagFormat));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("simpleteamchat") && sender.hasPermission("simpleteamchat.command") && args.length > 0) {
            if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("simpleteamchat.command.reload")) {
                this.loadConfig();
                sender.sendMessage(ChatColor.GREEN + "Reloaded config!");
                return true;
            } else {
                if (!args[0].equalsIgnoreCase("team") || !sender.hasPermission("simpleteamchat.command.team")) return false;
                if (args.length > 2) {
                    Team team = this.getServer().getScoreboardManager().getMainScoreboard().getTeam(args[1]);
                    if (team != null) {
                        String msg = args[2];
                        for (int i = 3; i < args.length; ++i) {
                            msg = msg + " " + args[i];
                        }
                        this.sendMessage(sender, team, msg);
                        return true;
                    } else {
                        sender.sendMessage(ChatColor.RED + "Kein Team mit dem Namen " + ChatColor.YELLOW + args[1] + ChatColor.RED + " gefunden!");
                    }
                    return true;
                } else {
                    sender.sendMessage("Usage: /" + label.toLowerCase() + " team <teamname> <msg>");
                }
            }
            return true;
        } else if (sender.hasPermission("SimpleTeamChat.chat")) {
            if (args.length == 0) {
                if (sender instanceof Player) {
                    if (cmd.getName().equalsIgnoreCase("teamchat")) {
                        Team senderTeam = this.getServer().getScoreboardManager().getMainScoreboard().getEntryTeam(sender.getName());
                        if (senderTeam != null) {
                            sender.sendMessage(ChatColor.GREEN + "Du sprichst nun in deinem Team-Kanal! Nutze /global bzw. /eglobal um im normalen Chat zu sprechen!");
                            this.playerChannels.put(((Player)sender).getUniqueId(), ChatDestination.TEAM);
                            return true;
                        } else {
                            sender.sendMessage(ChatColor.RED + "Du bist in keinem Team!");
                        }
                        return true;
                    } else {
                        if (!cmd.getName().equalsIgnoreCase("chat")) return true;
                        this.playerChannels.put(((Player)sender).getUniqueId(), ChatDestination.GLOBAL);
                        sender.sendMessage(ChatColor.GREEN + "Du sprichst nun im globalen Chat-Kanal!");
                    }
                    return true;
                } else {
                    sender.sendMessage("Die Konsole kann nur im globalen Channel sprechen ;)");
                }
                return true;
            } else {
                String msg = args[0];
                for (int i = 1; i < args.length; ++i) {
                    msg = msg + " " + args[i];
                }
                if (cmd.getName().equalsIgnoreCase("teamchat")) {
                    Team senderTeam = this.getServer().getScoreboardManager().getMainScoreboard().getEntryTeam(sender.getName());
                    if (senderTeam != null) {
                        this.sendMessage(sender, senderTeam, msg);
                        return true;
                    } else {
                        sender.sendMessage(ChatColor.RED + "Du bist in keinem Team!");
                    }
                    return true;
                } else {
                    if (!cmd.getName().equalsIgnoreCase("chat")) return true;
                    this.sendGlobalMessage(sender, msg);
                }
            }
            return true;
        } else {
            sender.sendMessage(ChatColor.RED + "Du hast nicht gen\u00fcgend Rechte um zu chatten!");
        }
        return true;
    }

    @EventHandler
    public void onCommandPreprocess(PlayerCommandPreprocessEvent event) {
        ArrayList<String> args;
        if (!event.isCancelled() && (args = new ArrayList<String>(Arrays.asList(event.getMessage().split(" ")))).size() > 0 && args.get(0).startsWith("/") && args.get(0).equalsIgnoreCase(this.globalChannel)) {
            event.setCancelled(true);
            args.remove(0);
            this.onCommand((CommandSender)event.getPlayer(), (Command)this.getServer().getPluginCommand("chat"), this.globalChannel, args.toArray(new String[args.size()]));
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (event.getPlayer().hasPermission("simpleteamchat.chat")) {
            ChatDestination destination = this.playerChannels.get(event.getPlayer().getUniqueId());
            if (event.getPlayer().hasPermission("simpleteamchat.chat.color")) {
                event.setMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)event.getMessage()));
            }
            if (destination == null || destination == ChatDestination.GLOBAL) {
                event.setFormat(this.getGlobalFormat((CommandSender)event.getPlayer()));
            } else {
                Team senderTeam = this.getServer().getScoreboardManager().getMainScoreboard().getEntryTeam(event.getPlayer().getName());
                if (senderTeam != null) {
                    this.sendMessage((CommandSender)event.getPlayer(), senderTeam, event.getMessage());
                    event.setCancelled(true);
                } else {
                    event.setFormat(this.getGlobalFormat((CommandSender)event.getPlayer()));
                    this.playerChannels.remove(event.getPlayer().getUniqueId());
                }
            }
        } else {
            event.getPlayer().sendMessage(ChatColor.RED + "Du hast nicht gen\u00fcgend Rechte um zu chatten!");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLogout(PlayerQuitEvent event) {
        this.playerChannels.remove(event.getPlayer().getUniqueId());
    }

    private void sendGlobalMessage(CommandSender sender, String msg) {
        if (sender.hasPermission("simpleteamchat.chat.color")) {
            msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        }
        String formattedMessage = String.format(this.getGlobalFormat(sender), sender.getName(), msg);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.sendMessage(formattedMessage);
        }
        this.getServer().getConsoleSender().sendMessage(formattedMessage);
    }

    private void sendMessage(CommandSender sender, Team team, String msg) {
        Object color;
        HashSet<Object> receivers = new HashSet<Object>();
        for (String entry : team.getEntries()) {
            Player player;
            if (entry.equalsIgnoreCase(sender.getName()) || (player = this.getServer().getPlayer(entry)) == null || !player.isOnline()) continue;
            receivers.add(player);
        }
        String teamColor = "";
        if (team.getPrefix().length() > 1 && (color = ChatColor.getByChar((char)team.getPrefix().charAt(1))) != null) {
            teamColor = teamColor + color;
        }
        receivers.add(sender);
        receivers.add(this.getServer().getConsoleSender());
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (!player.hasPermission("simpleteamchat.chat.spy")) continue;
            receivers.add(player);
        }
        if (sender.hasPermission("simpleteamchat.chat.color")) {
            msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        }
        String formattedMessage = String.format(this.getFormat(sender, ChatDestination.TEAM, teamColor, team.getDisplayName()), sender.getName(), msg);
        for (CommandSender commandSender : receivers) {
            commandSender.sendMessage(formattedMessage);
        }
    }

    private String getGlobalFormat(CommandSender sender) {
        return this.getFormat(sender, ChatDestination.GLOBAL, this.globalColor, this.globalChannel);
    }

    private String getFormat(CommandSender sender, ChatDestination destination, String channelColor, String channelTag) {
        ServerInfo serverInfo;
        String format = destination == ChatDestination.GLOBAL ? this.globalFormat : this.teamFormat;
        String tag = this.channelTagFormat.replace("%color%", channelColor).replace("%tag%", channelTag);
        format = format.replace("%tag%", tag);
        String info = "";
        if (this.serverTags != null && sender instanceof Player && (serverInfo = this.serverTags.getPlayerServer((Player)sender)) != null) {
            info = this.serverInfoFormat.replace("%tag%", serverInfo.getTag()).replace("%name%", serverInfo.getName());
        }
        format = format.replace("%serverinfo%", info);
        String prefix = "";
        String suffix = "";
        if (this.chat != null && sender instanceof Player) {
            prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.chat.getPlayerPrefix((Player)sender));
            suffix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.chat.getPlayerSuffix((Player)sender));
        }
        format = format.replace("%prefix%", prefix);
        format = format.replace("%suffix%", suffix);
        return format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChatDestination {
        GLOBAL,
        TEAM;

    }
}

