/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown.adventure;

import de.themoep.minedown.adventure.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class Replacer {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Function<String, Pattern> PATTERN_CREATOR = p -> Pattern.compile(p, 16);
    private final Map<String, String> replacements = new LinkedHashMap<String, String>();
    private final Map<String, Component> componentReplacements = new LinkedHashMap<String, Component>();
    private String placeholderPrefix = "%";
    private String placeholderSuffix = "%";
    private boolean ignorePlaceholderCase = true;

    public static String replaceIn(String message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static Component replaceIn(Component message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static Component replaceIn(Component message, String placeholder, Component replacement) {
        return new Replacer().replace(placeholder, replacement).replaceIn(message);
    }

    public Replacer replace(String ... replacements) {
        Util.validate(replacements.length % 2 == 0, "The replacement length has to be even, mapping i % 2 == 0 to the placeholder and i % 2 = 1 to the placeholder's value");
        LinkedHashMap<String, String> replacementMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < replacements.length) {
            replacementMap.put(replacements[i], replacements[i + 1]);
            i += 2;
        }
        return this.replace(replacementMap);
    }

    public Replacer replace(Map<String, ?> replacements) {
        if (replacements != null && !replacements.isEmpty()) {
            Object any = replacements.values().stream().filter(Objects::nonNull).findAny().orElse(null);
            if (any instanceof String) {
                this.replacements().putAll(replacements);
            } else if (any instanceof Component) {
                this.componentReplacements().putAll(replacements);
            } else {
                for (Map.Entry<String, ?> entry : replacements.entrySet()) {
                    this.replacements().put(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
        return this;
    }

    public Replacer replace(String placeholder, Component replacement) {
        this.componentReplacements().put(placeholder, replacement);
        return this;
    }

    public Replacer placeholderIndicator(String placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public List<Component> replaceIn(List<Component> components) {
        ArrayList<Component> replaced = new ArrayList<Component>();
        for (Component component : components) {
            replaced.add(this.replaceIn(component));
        }
        return replaced;
    }

    public Component replaceIn(Component component) {
        TextComponent.Builder builder = Component.text();
        if (component instanceof KeybindComponent) {
            component = ((KeybindComponent)component).keybind(this.replaceIn(((KeybindComponent)component).keybind()));
        }
        if (component instanceof TextComponent) {
            String replaced = this.replaceIn(((TextComponent)component).content());
            if (replaced.indexOf(167) != -1) {
                TextComponent replacedComponent = LegacyComponentSerializer.legacySection().deserialize(replaced);
                component = ((TextComponent)component).content("");
                ArrayList<Component> children = new ArrayList<Component>();
                children.add(replacedComponent);
                children.addAll(component.children());
                component = component.children(children);
            } else {
                component = ((TextComponent)component).content(replaced);
            }
        }
        if (component instanceof TranslatableComponent) {
            component = ((TranslatableComponent)component).key(this.replaceIn(((TranslatableComponent)component).key()));
            component = ((TranslatableComponent)component).args(this.replaceIn(((TranslatableComponent)component).args()));
        }
        if (component.insertion() != null) {
            component = component.insertion(this.replaceIn(component.insertion()));
        }
        if (component.clickEvent() != null) {
            component = component.clickEvent(ClickEvent.clickEvent(component.clickEvent().action(), this.replaceIn(component.clickEvent().value())));
        }
        if (component.hoverEvent() != null) {
            if (component.hoverEvent().action() == HoverEvent.Action.SHOW_TEXT) {
                component = component.hoverEvent(HoverEvent.showText(this.replaceIn((Component)component.hoverEvent().value())));
            } else if (component.hoverEvent().action() == HoverEvent.Action.SHOW_ENTITY) {
                HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)component.hoverEvent().value();
                component = component.hoverEvent(HoverEvent.showEntity(HoverEvent.ShowEntity.of(Key.key(this.replaceIn(showEntity.type().asString())), showEntity.id(), this.replaceIn(showEntity.name()))));
            } else if (component.hoverEvent().action() == HoverEvent.Action.SHOW_ITEM) {
                HoverEvent.ShowItem showItem = (HoverEvent.ShowItem)component.hoverEvent().value();
                component = component.hoverEvent(HoverEvent.showItem(HoverEvent.ShowItem.of(Key.key(this.replaceIn(showItem.item().asString())), showItem.count())));
            }
        }
        component = component.children(this.replaceIn(component.children()));
        ArrayList<Component> replacedComponents = new ArrayList<Component>();
        replacedComponents.add(component);
        for (Map.Entry<String, Component> replacement : this.componentReplacements().entrySet()) {
            ArrayList<Object> newReplacedComponents = new ArrayList<Object>();
            for (Component replaceComponent : replacedComponents) {
                if (replaceComponent instanceof TextComponent) {
                    TextComponent textComponent = (TextComponent)replaceComponent;
                    String placeHolder = this.placeholderPrefix() + (this.ignorePlaceholderCase() ? replacement.getKey().toLowerCase(Locale.ROOT) : replacement.getKey()) + this.placeholderSuffix();
                    String text = this.ignorePlaceholderCase() ? textComponent.content().toLowerCase(Locale.ROOT) : textComponent.content();
                    int index = text.indexOf(placeHolder);
                    if (index > -1) {
                        do {
                            TextComponent.Builder startBuilder = (TextComponent.Builder)Component.text().mergeStyle(textComponent);
                            if (index > 0) {
                                startBuilder.content(textComponent.content().substring(0, index));
                            }
                            startBuilder.append(replacement.getValue());
                            newReplacedComponents.add(startBuilder.build());
                            if (index + placeHolder.length() < textComponent.content().length()) {
                                textComponent = textComponent.content(textComponent.content().substring(index + placeHolder.length()));
                                newReplacedComponents.add(textComponent);
                                continue;
                            }
                            textComponent = textComponent.content("");
                        } while (!(text = this.ignorePlaceholderCase() ? textComponent.content().toLowerCase(Locale.ROOT) : textComponent.content()).isEmpty() && (index = text.indexOf(placeHolder)) > -1);
                        continue;
                    }
                }
                newReplacedComponents.add(replaceComponent);
            }
            replacedComponents = newReplacedComponents;
        }
        builder.append(replacedComponents);
        return builder.build();
    }

    public String replaceIn(String string) {
        for (Map.Entry<String, String> replacement : this.replacements().entrySet()) {
            String placeholder;
            String replValue;
            String string2 = replValue = replacement.getValue() != null ? replacement.getValue() : "null";
            if (this.ignorePlaceholderCase()) {
                int startIndex;
                placeholder = this.placeholderPrefix() + replacement.getKey().toLowerCase(Locale.ROOT) + this.placeholderSuffix();
                int nextStart = 0;
                while (nextStart < string.length() && (startIndex = string.toLowerCase(Locale.ROOT).indexOf(placeholder, nextStart)) > -1) {
                    nextStart = startIndex + replValue.length();
                    string = string.substring(0, startIndex) + replValue + string.substring(startIndex + placeholder.length());
                }
                continue;
            }
            placeholder = this.placeholderPrefix() + replacement.getKey() + this.placeholderSuffix();
            Pattern pattern = PATTERN_CACHE.computeIfAbsent(placeholder, PATTERN_CREATOR);
            string = pattern.matcher(string).replaceAll(Matcher.quoteReplacement(replValue));
        }
        return string;
    }

    public Replacer copy() {
        return new Replacer().copy(this);
    }

    public Replacer copy(Replacer from) {
        this.replacements().clear();
        this.replacements().putAll(from.replacements());
        this.componentReplacements().clear();
        this.componentReplacements().putAll(from.componentReplacements());
        this.placeholderPrefix(from.placeholderPrefix());
        this.placeholderSuffix(from.placeholderSuffix());
        return this;
    }

    public Map<String, String> replacements() {
        return this.replacements;
    }

    public Map<String, Component> componentReplacements() {
        return this.componentReplacements;
    }

    public String placeholderPrefix() {
        return this.placeholderPrefix;
    }

    public Replacer placeholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        return this;
    }

    public String placeholderSuffix() {
        return this.placeholderSuffix;
    }

    public Replacer placeholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        return this;
    }

    public boolean ignorePlaceholderCase() {
        return this.ignorePlaceholderCase;
    }

    public Replacer ignorePlaceholderCase(boolean ignorePlaceholderCase) {
        this.ignorePlaceholderCase = ignorePlaceholderCase;
        return this;
    }
}

