/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater;

import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.UpdateSource;
import java.util.LinkedHashMap;
import java.util.Map;

public class PluginConfig {
    private String name;
    private UpdateSource source;
    private String fileNameFormat;
    private Map<String, String> placeholders;

    public PluginConfig(String name, UpdateSource source, String fileNameFormat, Map<String, String> placeholders) {
        this.name = name;
        this.source = source;
        this.fileNameFormat = fileNameFormat;
        this.placeholders = new LinkedHashMap<String, String>(placeholders);
        this.placeholders.putIfAbsent("name", name);
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, String> getPlaceholders(String nameFallback) {
        if (this.getPlaceholders().containsKey(nameFallback)) {
            return this.getPlaceholders();
        }
        LinkedHashMap<String, String> placeholders = new LinkedHashMap<String, String>(this.getPlaceholders());
        placeholders.put(nameFallback, this.getName());
        return placeholders;
    }

    public String getFileName(String version) {
        return Replacer.replaceIn(this.fileNameFormat, "name", this.name, "version", Updater.sanitize(version), "rawversion", version);
    }

    public String getName() {
        return this.name;
    }

    public UpdateSource getSource() {
        return this.source;
    }
}

