/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.application;

import dev.phoenix616.updater.Updater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;

public class Main {
    private static String NAME = null;
    private static String VERSION = null;
    private static Properties p = new Properties();

    public static void main(String[] args) {
        Updater updater;
        try {
            InputStream s2 = Main.class.getClassLoader().getResourceAsStream("app.properties");
            p.load(s2);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        NAME = p.getProperty("application.name");
        VERSION = p.getProperty("application.version");
        System.out.print(NAME + " " + VERSION + "\nCopyright (C) 2020 Max Lee aka Phoenix616 (max@themoep.de)\n    By using this program you agree to the terms of the AGPLv3\n    The full license text can be found here: https://phoenix616.dev/licenses/agpl-v3.txt\n    This program's source is available here: https://github.com/Phoenix616/Updater\n");
        final File tempFolder = new File(System.getProperty("java.io.tmpdir"), NAME);
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
        }
        if (!(updater = new Updater(null){

            @Override
            protected boolean getDontLink() {
                return false;
            }

            @Override
            public void log(Level level, String message, Throwable ... exception) {
                if (level.intValue() >= this.getLogLevel().intValue()) {
                    System.out.println("[" + level + "] " + message);
                    for (Throwable throwable : exception) {
                        throwable.printStackTrace();
                    }
                }
            }

            @Override
            public File getTempFolder() {
                return tempFolder;
            }

            @Override
            public String getName() {
                return NAME;
            }

            @Override
            public String getVersion() {
                return VERSION;
            }
        }).run(args)) {
            System.out.print("Usage: " + p.getProperty("application.name") + ".jar <options>\n -t <path>, --target-folder <path> Target folder where updates get downloaded to (Required)\n -p <name>, --plugin <name>        Only check/update one plugin (Optional)\n -c, --check-only                  Only check for new versions, don't download updates (Optional)\n -d, --dont-link                   Only download new versions, don't link them (Optional)\n -l <level>, --log-level <level>   Only print messages of the specified level or higher (Optional, default: INFO)\n");
        }
        tempFolder.delete();
    }
}

