/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class BukkitSource
extends UpdateSource {
    private static final List<String> REQUIRED_PLACEHOLDERS = Arrays.asList("pluginid");
    private static final String VERSION_URL = "https://api.curseforge.com/servermods/files?projectIds=%pluginid%";

    public BukkitSource(Updater updater) {
        super(updater, SourceType.BUKKIT, REQUIRED_PLACEHOLDERS);
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        block6: {
            try {
                String s2;
                String[] properties = new String[]{};
                if (config.getPlaceholders().containsKey("apikey")) {
                    properties = new String[]{"X-API-Key", config.getPlaceholders().get("apikey")};
                }
                if ((s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(VERSION_URL)), properties)) == null) break block6;
                try {
                    JsonElement json = new JsonParser().parse(s2);
                    if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                        JsonObject lastUpdate = ((JsonArray)json).get(((JsonArray)json).size() - 1).getAsJsonObject();
                        return lastUpdate.get("name").getAsString();
                    }
                }
                catch (JsonParseException | IllegalStateException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    private JsonObject getUpdateInfo(PluginConfig config) throws MalformedURLException, JsonParseException {
        JsonElement json;
        String s2;
        String[] properties = new String[]{};
        if (config.getPlaceholders().containsKey("apikey")) {
            properties = new String[]{"X-API-Key", config.getPlaceholders().get("apikey")};
        }
        if ((s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(VERSION_URL)), properties)) != null && (json = new JsonParser().parse(s2)).isJsonArray() && ((JsonArray)json).size() > 0) {
            return ((JsonArray)json).get(((JsonArray)json).size() - 1).getAsJsonObject();
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        try {
            JsonObject lastUpdate = this.getUpdateInfo(config);
            if (lastUpdate != null) {
                String downloadUrl = lastUpdate.get("fileUrl").getAsString();
                return new URL(downloadUrl);
            }
        }
        catch (JsonParseException e) {
            this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ". Error: " + e.getMessage(), new Throwable[0]);
        }
        throw new FileNotFoundException("Not found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        try {
            try {
                JsonObject lastUpdate = this.getUpdateInfo(config);
                String version = lastUpdate.get("name").getAsString();
                String downloadUrl = lastUpdate.get("fileUrl").getAsString();
                String md5 = lastUpdate.get("md5").getAsString();
                File target = new File(this.updater.getTempFolder(), config.getName() + "-" + lastUpdate.get("fileName").getAsString());
                try {
                    URL source = new URL(downloadUrl);
                    HttpURLConnection con = (HttpURLConnection)source.openConnection();
                    con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                    if (config.getPlaceholders().containsKey("apikey")) {
                        con.setRequestProperty("X-API-Key", config.getPlaceholders().get("apikey"));
                    }
                    con.setUseCaches(false);
                    con.connect();
                    try (InputStream in = con.getInputStream();){
                        if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                        byte[] hash = MessageDigest.getInstance("MD5").digest(Files.readAllBytes(target.toPath()));
                        String stringHash = String.format("%x", new BigInteger(1, hash));
                        if (md5.equalsIgnoreCase(stringHash)) {
                            File file = target;
                            return file;
                        }
                        this.updater.log(Level.SEVERE, "Check sum of file (" + stringHash + ") does not match provided one (" + md5 + ")", new Throwable[0]);
                        return null;
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                    return null;
                }
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ". Error: " + e.getMessage(), new Throwable[0]);
                return null;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }
}

