/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Level;

public class DirectSource
extends UpdateSource {
    private final String latestVersion;
    private final String download;

    public DirectSource(String name, Updater updater, String latestVersion, String download, List<String> requiredPlaceholders) {
        super(updater, SourceType.DIRECT, name, requiredPlaceholders);
        this.latestVersion = latestVersion;
        this.download = download;
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        try {
            String r = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(this.latestVersion)), new String[0]);
            if (r != null && !r.isEmpty()) {
                return r;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest direct version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException {
        return new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(this.download));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        String version = this.getLatestVersion(config);
        if (version == null) return null;
        try {
            URL source = this.getUpdateUrl(config);
            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + source.getPath().substring(source.getPath().lastIndexOf(47) + 1));
            HttpURLConnection con = (HttpURLConnection)source.openConnection();
            con.setUseCaches(false);
            con.setRequestProperty("User-Agent", this.updater.getUserAgent());
            con.connect();
            try (InputStream in = con.getInputStream();){
                if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                File file = target;
                return file;
            }
        }
        catch (IOException e) {
            this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }
}

