/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.ContentType;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GitHubSource
extends UpdateSource {
    private static final List<String> REQUIRED_PLACEHOLDERS = Arrays.asList("user");
    private static final String API_HEADER = "application/vnd.github.v3+json";
    private static final String RELEASES_URL = "https://api.github.com/repos/%user%/%repository%/releases";

    public GitHubSource(Updater updater) {
        super(updater, SourceType.GITHUB, REQUIRED_PLACEHOLDERS);
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        try {
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", API_HEADER));
            if (config.getPlaceholders().containsKey("token")) {
                Collections.addAll(properties, "Authorization", "token " + config.getPlaceholders().get("token"));
            } else if (config.getPlaceholders().containsKey("username") && config.getPlaceholders().containsKey("password")) {
                String userPass = config.getPlaceholders().get("username") + ":" + config.getPlaceholders().get("password");
                Collections.addAll(properties, "Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
            }
            String s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders("repository")).replaceIn(RELEASES_URL)), properties.toArray(new String[0]));
            if (s2 != null) {
                try {
                    JsonElement json = new JsonParser().parse(s2);
                    if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                        for (JsonElement release : (JsonArray)json) {
                            if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonArray()) continue;
                            for (JsonElement asset : ((JsonObject)release).getAsJsonArray("assets")) {
                                if (!this.matches(config, asset)) continue;
                                return ((JsonObject)release).get("tag_name").getAsString();
                            }
                        }
                    }
                    this.updater.log(Level.WARNING, "Json did not contain release entry for " + config.getName() + " from source " + this.getName() + ": " + json, new Throwable[0]);
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            } else {
                this.updater.log(Level.WARNING, "Query didn't return anything for " + config.getName() + " from source " + this.getName() + "!", new Throwable[0]);
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", API_HEADER));
        if (config.getPlaceholders().containsKey("token")) {
            Collections.addAll(properties, "Authorization", "token " + config.getPlaceholders().get("token"));
        } else if (config.getPlaceholders().containsKey("username") && config.getPlaceholders().containsKey("password")) {
            String userPass = config.getPlaceholders().get("username") + ":" + config.getPlaceholders().get("password");
            Collections.addAll(properties, "Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
        }
        String s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders("repository")).replaceIn(RELEASES_URL)), properties.toArray(new String[0]));
        if (s2 != null) {
            try {
                JsonElement json = new JsonParser().parse(s2);
                if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                    for (JsonElement release : (JsonArray)json) {
                        if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonArray()) continue;
                        for (JsonElement asset : (JsonArray)((JsonObject)release).get("assets")) {
                            if (!this.matches(config, asset)) continue;
                            return new URL(((JsonObject)asset).get("browser_download_url").getAsString());
                        }
                    }
                }
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
            }
        }
        throw new FileNotFoundException("Not found");
    }

    private boolean matches(PluginConfig config, JsonElement asset) {
        String contentType;
        if (asset.isJsonObject() && ((JsonObject)asset).has("browser_download_url") && ((JsonObject)asset).has("content_type") && ((JsonObject)asset).has("name") && (ContentType.JAR.matches(contentType = ((JsonObject)asset).get("content_type").getAsString()) || ContentType.ZIP.matches(contentType))) {
            String filePatternString = config.getPlaceholders().get("file-pattern");
            if (filePatternString == null) {
                return true;
            }
            try {
                Pattern filePattern = Pattern.compile(filePatternString);
                String name = ((JsonObject)asset).get("name").getAsString();
                return filePattern.matcher(name).matches();
            }
            catch (PatternSyntaxException ex) {
                this.updater.log(Level.SEVERE, "Could not compile file-pattern regex " + filePatternString + " for " + config.getName(), new Throwable[0]);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        block19: {
            try {
                ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", API_HEADER));
                if (config.getPlaceholders().containsKey("token")) {
                    Collections.addAll(properties, "Authorization", "token " + config.getPlaceholders().get("token"));
                } else if (config.getPlaceholders().containsKey("username") && config.getPlaceholders().containsKey("password")) {
                    String userPass = config.getPlaceholders().get("username") + ":" + config.getPlaceholders().get("password");
                    Collections.addAll(properties, "Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
                }
                String s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders("repository")).replaceIn(RELEASES_URL)), properties.toArray(new String[0]));
                if (s2 == null) break block19;
                try {
                    JsonElement json = new JsonParser().parse(s2);
                    if (!json.isJsonArray() || ((JsonArray)json).size() <= 0) break block19;
                    for (JsonElement release : (JsonArray)json) {
                        if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonArray()) continue;
                        for (JsonElement asset : (JsonArray)((JsonObject)release).get("assets")) {
                            if (!this.matches(config, asset)) continue;
                            String version = ((JsonObject)release).get("tag_name").getAsString();
                            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + ((JsonObject)asset).get("name").getAsString());
                            try {
                                URL source = new URL(((JsonObject)asset).get("browser_download_url").getAsString());
                                HttpURLConnection con = (HttpURLConnection)source.openConnection();
                                con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                                con.addRequestProperty("Accept", API_HEADER);
                                con.addRequestProperty("Accept", "application/octet-stream");
                                if (config.getPlaceholders().containsKey("token")) {
                                    con.addRequestProperty("Authorization", "token " + config.getPlaceholders().get("token"));
                                } else if (config.getPlaceholders().containsKey("username") && config.getPlaceholders().containsKey("password")) {
                                    String userPass = config.getPlaceholders().get("username") + ":" + config.getPlaceholders().get("password");
                                    con.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
                                }
                                con.setUseCaches(false);
                                con.connect();
                                InputStream in = con.getInputStream();
                                try {
                                    if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) continue;
                                    File file = target;
                                    return file;
                                }
                                finally {
                                    if (in == null) continue;
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                            }
                        }
                    }
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }
}

