/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class GitLabSource
extends UpdateSource {
    private static final List<String> REQUIRED_PLACEHOLDERS = Arrays.asList("user");
    private static final String API_URL = "https://gitlab.com/api/v4/";
    private static final String RELEASES_URL = "%apiurl%projects/%user%%2F%repository%/releases";

    public GitLabSource(Updater updater) {
        super(updater, SourceType.GITLAB, REQUIRED_PLACEHOLDERS);
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        block8: {
            try {
                String s2;
                Replacer replacer = new Replacer().replace("apiurl", API_URL).replace(config.getPlaceholders("repository"));
                String[] properties = new String[]{};
                if (config.getPlaceholders().containsKey("token")) {
                    properties = new String[]{"Private-Token", config.getPlaceholders().get("token")};
                }
                if ((s2 = this.updater.query(new URL(replacer.replaceIn(RELEASES_URL)), properties)) == null) break block8;
                try {
                    JsonElement json = new JsonParser().parse(s2);
                    if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                        for (JsonElement release : (JsonArray)json) {
                            JsonObject assets;
                            if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonObject() || !(assets = ((JsonObject)release).getAsJsonObject("assets")).has("links") || !assets.get("links").isJsonArray()) continue;
                            for (JsonElement asset : assets.getAsJsonArray("links")) {
                                if (!asset.isJsonObject() || !((JsonObject)asset).get("name").getAsString().endsWith(".jar") && !((JsonObject)asset).get("url").getAsString().endsWith(".jar")) continue;
                                return ((JsonObject)release).get("tag_name").getAsString();
                            }
                        }
                    }
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        Replacer replacer = new Replacer().replace("apiurl", API_URL).replace(config.getPlaceholders("repository"));
        String s2 = this.updater.query(new URL(replacer.replaceIn(RELEASES_URL)), "Accept", "application/vnd.github.v3+json");
        if (s2 != null) {
            try {
                JsonElement json = new JsonParser().parse(s2);
                if (json.isJsonArray() && ((JsonArray)json).size() > 0) {
                    for (JsonElement release : (JsonArray)json) {
                        JsonObject assets;
                        if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonObject() || !(assets = ((JsonObject)release).getAsJsonObject("assets")).has("links") || !assets.get("links").isJsonArray()) continue;
                        for (JsonElement asset : assets.getAsJsonArray("links")) {
                            if (!asset.isJsonObject() || !((JsonObject)asset).get("name").getAsString().endsWith(".jar") && !((JsonObject)asset).get("url").getAsString().endsWith(".jar")) continue;
                            return new URL(((JsonObject)asset).get("url").getAsString());
                        }
                    }
                }
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
            }
        }
        throw new FileNotFoundException("Not found");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        block14: {
            try {
                Replacer replacer = new Replacer().replace("apiurl", API_URL).replace(config.getPlaceholders("repository"));
                String s2 = this.updater.query(new URL(replacer.replaceIn(RELEASES_URL)), "Accept", "application/vnd.github.v3+json");
                if (s2 == null) break block14;
                try {
                    JsonElement json = new JsonParser().parse(s2);
                    if (!json.isJsonArray() || ((JsonArray)json).size() <= 0) break block14;
                    for (JsonElement release : (JsonArray)json) {
                        JsonObject assets;
                        if (!release.isJsonObject() || !((JsonObject)release).has("tag_name") || !((JsonObject)release).has("assets") || !((JsonObject)release).get("assets").isJsonObject() || !(assets = ((JsonObject)release).getAsJsonObject("assets")).has("links") || !assets.get("links").isJsonArray()) continue;
                        for (JsonElement asset : assets.getAsJsonArray("links")) {
                            if (!asset.isJsonObject() || !((JsonObject)asset).get("name").getAsString().endsWith(".jar") && !((JsonObject)asset).get("url").getAsString().endsWith(".jar")) continue;
                            String version = ((JsonObject)release).get("tag_name").getAsString();
                            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + ((JsonObject)asset).get("name").getAsString());
                            try {
                                URL source = new URL(((JsonObject)asset).get("url").getAsString());
                                HttpURLConnection con = (HttpURLConnection)source.openConnection();
                                con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                                if (config.getPlaceholders().containsKey("token")) {
                                    con.setRequestProperty("Private-Token", config.getPlaceholders().get("token"));
                                }
                                con.setUseCaches(false);
                                con.connect();
                                InputStream in = con.getInputStream();
                                try {
                                    if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) continue;
                                    File file = target;
                                    return file;
                                }
                                finally {
                                    if (in == null) continue;
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                            }
                        }
                    }
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }
}

