/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;

public class ModrinthSource
extends UpdateSource {
    private static final List<String> REQUIRED_PLACEHOLDERS = Arrays.asList("user");
    private static final String API_HEADER = "application/json";
    private static final String VERSION_URL = "https://api.modrinth.com/v2/project/%project%/versions&featured=%featured%";

    public ModrinthSource(Updater updater) {
        super(updater, SourceType.MODRINTH, REQUIRED_PLACEHOLDERS);
    }

    private Optional<ReleaseInfo> getLatestRelease(PluginConfig config) {
        block8: {
            try {
                String s2;
                Object versionUrl = VERSION_URL;
                ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", API_HEADER));
                if (config.getPlaceholders().containsKey("platform")) {
                    versionUrl = (String)versionUrl + "&loaders=[\"%platform%\"]";
                }
                if (config.getPlaceholders().containsKey("platform-version")) {
                    versionUrl = (String)versionUrl + "&game_versions=[\"%platform-version%\"]";
                }
                if (!config.getPlaceholders().containsKey("featured")) {
                    config.getPlaceholders().put("featured", "true");
                }
                if ((s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders("project")).replaceIn((String)versionUrl)), properties.toArray(new String[0]))) == null) break block8;
                try {
                    JsonElement release;
                    JsonArray versionArray;
                    JsonElement json = new JsonParser().parse(s2);
                    if (json.isJsonArray() && (versionArray = json.getAsJsonArray()).size() > 0 && (release = versionArray.get(0)).isJsonObject()) {
                        return Optional.ofNullable(this.buildReleaseInfo(release.getAsJsonObject()));
                    }
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return Optional.empty();
    }

    private ReleaseInfo buildReleaseInfo(JsonObject release) throws MalformedURLException {
        JsonElement versionElement;
        if (release != null && release.has("files") && release.get("files").isJsonArray() && (versionElement = release.get("version_number")) != null && versionElement.isJsonPrimitive()) {
            String version = versionElement.getAsString();
            JsonArray downloads = release.getAsJsonArray("files");
            for (JsonElement fileEntry : downloads) {
                JsonObject hashes;
                JsonObject file;
                if (!fileEntry.isJsonObject() || (file = fileEntry.getAsJsonObject()).has("primary") && file.get("primary").isJsonPrimitive() && file.getAsJsonPrimitive("primary").isBoolean() && !file.get("primary").getAsBoolean() || !file.has("url") || !file.get("url").isJsonPrimitive()) continue;
                String sha1hash = null;
                if (file.has("hashes") && file.get("hashes").isJsonObject() && (hashes = file.getAsJsonObject("hashes")).has("sha1") && hashes.get("sha1").isJsonPrimitive()) {
                    sha1hash = hashes.get("sha1").getAsString();
                }
                return new ReleaseInfo(version, new URL(file.get("url").getAsString()), sha1hash);
            }
        }
        return null;
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        return this.getLatestRelease(config).map(ReleaseInfo::version).orElse(null);
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        Optional<ReleaseInfo> release = this.getLatestRelease(config);
        if (release.isPresent()) {
            return release.get().url();
        }
        throw new FileNotFoundException("Not found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        Optional<ReleaseInfo> release = this.getLatestRelease(config);
        if (!release.isPresent()) {
            this.updater.log(Level.SEVERE, "Unable to get download for " + config.getName() + " from source " + this.getName() + "!", new Throwable[0]);
            return null;
        }
        try {
            File target = new File(this.updater.getTempFolder(), config.getName() + "-" + release.get().version() + ".jar");
            HttpURLConnection con = (HttpURLConnection)release.get().url().openConnection();
            con.setRequestProperty("User-Agent", this.updater.getUserAgent());
            con.setUseCaches(false);
            con.connect();
            try (InputStream in = con.getInputStream();){
                if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                if (release.get().sha1hash() != null) {
                    byte[] hash = MessageDigest.getInstance("SHA1").digest(Files.readAllBytes(target.toPath()));
                    String stringHash = String.format("%x", new BigInteger(1, hash));
                    if (release.get().sha1hash().equalsIgnoreCase(stringHash)) {
                        File file = target;
                        return file;
                    }
                    this.updater.log(Level.SEVERE, "Check sum of file (" + stringHash + ") does not match provided one (" + release.get().sha1hash() + ")", new Throwable[0]);
                    return null;
                }
                File file = target;
                return file;
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.updater.log(Level.SEVERE, "Error while trying to download update " + release.get().version() + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            return null;
        }
    }

    private record ReleaseInfo(String version, URL url, String sha1hash) {
    }
}

