/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;

public class SpigotSource
extends UpdateSource {
    private static final List<String> REQUIRED_PLACEHOLDERS = Arrays.asList("resourceid");
    private static final String VERSION_URL = "https://api.spiget.org/v2/resources/%resourceid%/versions/latest";
    private static final String DOWNLOAD_URL = "https://api.spiget.org/v2/resources/%resourceid%/versions/%versionid%/download";
    private static final String DETAILS_URL = "https://api.spiget.org/v2/resources/%resourceid%";

    public SpigotSource(Updater updater) {
        super(updater, SourceType.SPIGOT, REQUIRED_PLACEHOLDERS);
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        block5: {
            try {
                String s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(VERSION_URL)), new String[0]);
                if (s2 == null) break block5;
                try {
                    JsonElement json = new JsonParser().parse(s2);
                    if (json.isJsonObject() && ((JsonObject)json).has("name") && ((JsonObject)json).has("id")) {
                        return ((JsonObject)json).get("name").getAsString();
                    }
                }
                catch (JsonParseException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        String s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(VERSION_URL)), new String[0]);
        if (s2 != null) {
            try {
                JsonElement json = new JsonParser().parse(s2);
                if (json.isJsonObject() && ((JsonObject)json).has("name") && ((JsonObject)json).has("id")) {
                    long id = ((JsonObject)json).get("id").getAsLong();
                    return new URL(new Replacer().replace(config.getPlaceholders()).replace("versionid", String.valueOf(id)).replaceIn(DOWNLOAD_URL));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
            }
        }
        throw new FileNotFoundException("Not found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        try {
            String s2 = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(VERSION_URL)), new String[0]);
            if (s2 == null) return null;
            try {
                JsonElement json = new JsonParser().parse(s2);
                if (!json.isJsonObject()) return null;
                if (!((JsonObject)json).has("name")) return null;
                if (!((JsonObject)json).has("id")) return null;
                String version = ((JsonObject)json).get("name").getAsString();
                long id = ((JsonObject)json).get("id").getAsLong();
                File target = new File(this.updater.getTempFolder(), config.getFileName(version));
                URL source = new URL(new Replacer().replace(config.getPlaceholders()).replace("versionid", String.valueOf(id)).replaceIn(DOWNLOAD_URL));
                try {
                    Matcher matcher;
                    String linkStr;
                    Map.Entry<String, JsonElement> link;
                    HttpURLConnection con = (HttpURLConnection)source.openConnection();
                    con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                    con.setUseCaches(false);
                    con.connect();
                    if (con.getResponseCode() == 200) {
                        try (InputStream in = con.getInputStream();){
                            if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) return null;
                            File file = target;
                            return file;
                        }
                    }
                    this.updater.log(Level.SEVERE, "Unable to download " + version + " for " + config.getName() + " from source " + this.getName() + "! " + con.getResponseMessage(), new Throwable[0]);
                    if (con.getResponseCode() != 503) return null;
                    String details = this.updater.query(new URL(new Replacer().replace(config.getPlaceholders()).replaceIn(DETAILS_URL)), new String[0]);
                    JsonObject detailsJson = new JsonParser().parse(details).getAsJsonObject();
                    if (!detailsJson.has("links")) return null;
                    if (detailsJson.get("links").getAsJsonObject().size() <= 0) return null;
                    Iterator<Map.Entry<String, JsonElement>> iterator = detailsJson.get("links").getAsJsonObject().entrySet().iterator();
                    do {
                        if (!iterator.hasNext()) return null;
                    } while (!(link = iterator.next()).getValue().isJsonPrimitive() || !((JsonPrimitive)link.getValue()).isString() || !(linkStr = link.getValue().getAsString()).contains("github.com/") || !(matcher = Updater.GITHUB_PATTERN.matcher(linkStr)).matches());
                    String ghUser = matcher.group("user");
                    String ghRepository = matcher.group("repo");
                    this.updater.log(Level.INFO, "Found GitHub repository at " + ghUser + "/" + ghRepository + ". Checking if it has releases!", new Throwable[0]);
                    config.getPlaceholders().put("user", ghUser);
                    config.getPlaceholders().put("repository", ghRepository);
                    UpdateSource ghSource = this.updater.getSource(SourceType.GITHUB.name());
                    String ghVersion = ghSource.getLatestVersion(config);
                    if (ghVersion == null) {
                        this.updater.log(Level.WARNING, "Unable to find release on GitHub. Here is the URL to manually download it from Spigot: " + source, new Throwable[0]);
                        return null;
                    }
                    if (Updater.sanitize(ghVersion).equalsIgnoreCase(Updater.sanitize(version))) {
                        this.updater.log(Level.INFO, "Found matching release on GitHub: " + ghVersion + ". Downloading it...", new Throwable[0]);
                        return ghSource.downloadUpdate(config);
                    }
                    this.updater.log(Level.WARNING, "Found non-matching release on GitHub: " + ghVersion + ". Spigot version was " + version + ". If you would like to download the update from GitHub instead then please adjust your plugins config!", new Throwable[0]);
                    return null;
                }
                catch (IOException e) {
                    this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                    return null;
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                return null;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }
}

