/*
 * Decompiled with CFR 0.152.
 */
package dev.phoenix616.updater.sources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.themoep.minedown.adventure.Replacer;
import dev.phoenix616.updater.PluginConfig;
import dev.phoenix616.updater.Updater;
import dev.phoenix616.updater.sources.SourceType;
import dev.phoenix616.updater.sources.UpdateSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TeamCitySource
extends UpdateSource {
    private static final List<String> REQUIRED_PLACEHOLDERS = Arrays.asList("buildtype");
    private static final String BUILD_URL = "%apiurl%/app/rest/builds/project:%project%,status:SUCCESS,branch:%branch%,buildType:%buildtype%";
    private static final String ARTIFACTS_URL = "%apiurl%/app/rest/builds/id:%buildid%/artifacts";
    private static final String ARTIFACT_DOWNLOAD_URL = "%apiurl%/app/rest/builds/id:%buildid%/artifacts/content/%filename%";
    private final String url;
    private final String token;

    public TeamCitySource(String name, Updater updater, String url, String token) {
        super(updater, SourceType.TEAMCITY, name, REQUIRED_PLACEHOLDERS);
        this.url = url;
        this.token = token;
    }

    private String getUrl(String url) {
        if (this.token == null && !((String)url).contains("guest=1")) {
            url = ((String)url).contains("?") ? (String)url + "&" : (String)url + "?";
            url = (String)url + "guest=1";
        }
        return url;
    }

    @Override
    public String getLatestVersion(PluginConfig config) {
        block6: {
            try {
                String s2;
                ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", "application/json"));
                if (this.token != null) {
                    Collections.addAll(properties, "Authorization", "Bearer " + this.token);
                }
                if ((s2 = this.updater.query(new URL(this.getReplacer(config).replaceIn(this.getUrl(BUILD_URL))), properties.toArray(new String[0]))) == null) break block6;
                try {
                    JsonObject json = new JsonParser().parse(s2).getAsJsonObject();
                    if (json.has("number")) {
                        return json.get("number").getAsString();
                    }
                }
                catch (JsonParseException | IllegalStateException e) {
                    this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                }
            }
            catch (MalformedURLException e) {
                this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
            }
        }
        return null;
    }

    @Override
    public URL getUpdateUrl(PluginConfig config) throws MalformedURLException, FileNotFoundException {
        String s2;
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", "application/json"));
        if (this.token != null) {
            Collections.addAll(properties, "Authorization", "Bearer " + this.token);
        }
        if ((s2 = this.updater.query(new URL(this.getReplacer(config).replaceIn(this.getUrl(BUILD_URL))), properties.toArray(new String[0]))) != null) {
            try {
                JsonObject artifactInfoJson;
                String id;
                String artifactInfo;
                JsonObject json = new JsonParser().parse(s2).getAsJsonObject();
                if (json.has("number") && (artifactInfo = this.updater.query(new URL(new Replacer().replace("apiurl", this.url, "buildid", id = json.get("id").getAsString()).replace(config.getPlaceholders("project")).replaceIn(this.getUrl(ARTIFACTS_URL))), properties.toArray(new String[0]))) != null && (artifactInfoJson = new JsonParser().parse(artifactInfo).getAsJsonObject()).has("file")) {
                    JsonArray files = artifactInfoJson.getAsJsonArray("file");
                    for (JsonElement file : files) {
                        if (!file.isJsonObject() || !((JsonObject)file).has("name") || !((JsonObject)file).get("name").getAsString().endsWith(".jar")) continue;
                        String fileName = ((JsonObject)file).get("name").getAsString();
                        return new URL(new Replacer().replace("apiurl", this.url, "buildid", id, "filename", fileName).replace(config.getPlaceholders("project")).replaceIn(this.getUrl(ARTIFACT_DOWNLOAD_URL)));
                    }
                }
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
            }
        }
        throw new FileNotFoundException("Not found");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File downloadUpdate(PluginConfig config) {
        try {
            String s2;
            ArrayList<String> properties = new ArrayList<String>(Arrays.asList("Accept", "application/json"));
            if (this.token != null) {
                Collections.addAll(properties, "Authorization", "Bearer " + this.token);
            }
            if ((s2 = this.updater.query(new URL(this.getReplacer(config).replaceIn(this.getUrl(BUILD_URL))), properties.toArray(new String[0]))) == null) return null;
            try {
                JsonObject json = new JsonParser().parse(s2).getAsJsonObject();
                if (!json.has("number")) return null;
                String version = json.get("number").getAsString();
                String id = json.get("id").getAsString();
                String artifactInfo = this.updater.query(new URL(new Replacer().replace("apiurl", this.url, "buildid", id).replace(config.getPlaceholders("project")).replaceIn(this.getUrl(ARTIFACTS_URL))), properties.toArray(new String[0]));
                if (artifactInfo == null) return null;
                JsonObject artifactInfoJson = new JsonParser().parse(artifactInfo).getAsJsonObject();
                if (!artifactInfoJson.has("file")) return null;
                JsonArray files = artifactInfoJson.getAsJsonArray("file");
                Iterator<JsonElement> iterator = files.iterator();
                while (iterator.hasNext()) {
                    JsonElement file = iterator.next();
                    if (!file.isJsonObject() || !((JsonObject)file).has("name") || !((JsonObject)file).get("name").getAsString().endsWith(".jar")) continue;
                    String fileName = ((JsonObject)file).get("name").getAsString();
                    File target = new File(this.updater.getTempFolder(), config.getName() + "-" + fileName);
                    try {
                        URL source = new URL(new Replacer().replace("apiurl", this.url, "buildid", id, "filename", fileName).replace(config.getPlaceholders("project")).replaceIn(this.getUrl(ARTIFACT_DOWNLOAD_URL)));
                        HttpURLConnection con = (HttpURLConnection)source.openConnection();
                        con.setRequestProperty("User-Agent", this.updater.getUserAgent());
                        if (this.token != null) {
                            con.setRequestProperty("Authorization", "Bearer " + this.token);
                        }
                        con.setUseCaches(false);
                        con.connect();
                        InputStream in = con.getInputStream();
                        try {
                            if (Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING) <= 0L) continue;
                            File file2 = target;
                            return file2;
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        this.updater.log(Level.SEVERE, "Error while trying to download update " + version + " for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
                    }
                }
                return null;
            }
            catch (JsonParseException e) {
                this.updater.log(Level.SEVERE, "Invalid Json returned when getting latest version for " + config.getName() + " from source " + this.getName() + ": " + s2 + ". Error: " + e.getMessage(), new Throwable[0]);
                return null;
            }
        }
        catch (MalformedURLException e) {
            this.updater.log(Level.SEVERE, "Invalid URL for getting latest version for " + config.getName() + " from source " + this.getName() + "! " + e.getMessage(), new Throwable[0]);
        }
        return null;
    }

    private Replacer getReplacer(PluginConfig config) {
        Replacer replacer = new Replacer().replace("apiurl", this.url, "branch", "default:any");
        for (Map.Entry<String, String> entry : config.getPlaceholders("project").entrySet()) {
            if (entry.getValue().contains("/")) {
                replacer.replace(entry.getKey(), "($base64:" + Base64.getEncoder().encodeToString(entry.getValue().getBytes()) + ")");
                continue;
            }
            replacer.replace(entry.getKey(), entry.getValue());
        }
        return replacer;
    }
}

