/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.TextReplacementConfigImpl;
import net.kyori.adventure.text.TextReplacementRenderer;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.util.Buildable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.string.StringExaminer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractComponent
implements Component {
    protected final List<Component> children;
    protected final Style style;

    static List<Component> asComponents(List<? extends ComponentLike> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>(list.size());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ComponentLike like = list.get(i);
            Component component = like.asComponent();
            if (component == Component.empty()) continue;
            components.add(component);
        }
        return Collections.unmodifiableList(components);
    }

    static <T> List<T> addOne(List<T> oldList, T newElement) {
        if (oldList.isEmpty()) {
            return Collections.singletonList(newElement);
        }
        ArrayList<T> newList = new ArrayList<T>(oldList.size() + 1);
        newList.addAll(oldList);
        newList.add(newElement);
        return newList;
    }

    protected AbstractComponent(@NonNull List<? extends ComponentLike> children, @NonNull Style style) {
        this.children = AbstractComponent.asComponents(children);
        this.style = style;
    }

    @Override
    public final @NonNull List<Component> children() {
        return this.children;
    }

    @Override
    public final @NonNull Style style() {
        return this.style;
    }

    @Override
    public @NonNull Component replaceText(@NonNull Consumer<TextReplacementConfig.Builder> configurer) {
        Objects.requireNonNull(configurer, "configurer");
        return this.replaceText((TextReplacementConfig)Buildable.configureAndBuild(TextReplacementConfig.builder(), configurer));
    }

    @Override
    public @NonNull Component replaceText(@NonNull TextReplacementConfig config) {
        Objects.requireNonNull(config, "replacement");
        if (!(config instanceof TextReplacementConfigImpl)) {
            throw new IllegalArgumentException("Provided replacement was a custom TextReplacementConfig implementation, which is not supported.");
        }
        return TextReplacementRenderer.INSTANCE.render((Component)this, ((TextReplacementConfigImpl)config).createState());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractComponent)) {
            return false;
        }
        AbstractComponent that = (AbstractComponent)other;
        return Objects.equals(this.children, that.children) && Objects.equals(this.style, that.style);
    }

    public int hashCode() {
        int result = this.children.hashCode();
        result = 31 * result + this.style.hashCode();
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("children", this.children), ExaminableProperty.of("style", this.style));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }
}

