/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.NBTComponentImpl;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StorageNBTComponentImpl
extends NBTComponentImpl<StorageNBTComponent, StorageNBTComponent.Builder>
implements StorageNBTComponent {
    private final Key storage;

    StorageNBTComponentImpl(@NonNull List<? extends ComponentLike> children, @NonNull Style style, String nbtPath, boolean interpret, Key storage) {
        super(children, style, nbtPath, interpret);
        this.storage = storage;
    }

    @Override
    public @NonNull StorageNBTComponent nbtPath(@NonNull String nbtPath) {
        if (Objects.equals(this.nbtPath, nbtPath)) {
            return this;
        }
        return new StorageNBTComponentImpl(this.children, this.style, nbtPath, this.interpret, this.storage);
    }

    @Override
    public @NonNull StorageNBTComponent interpret(boolean interpret) {
        if (this.interpret == interpret) {
            return this;
        }
        return new StorageNBTComponentImpl(this.children, this.style, this.nbtPath, interpret, this.storage);
    }

    @Override
    public @NonNull Key storage() {
        return this.storage;
    }

    @Override
    public @NonNull StorageNBTComponent storage(@NonNull Key storage) {
        if (Objects.equals(this.storage, storage)) {
            return this;
        }
        return new StorageNBTComponentImpl(this.children, this.style, this.nbtPath, this.interpret, storage);
    }

    @Override
    public @NonNull StorageNBTComponent children(@NonNull List<? extends ComponentLike> children) {
        return new StorageNBTComponentImpl(children, this.style, this.nbtPath, this.interpret, this.storage);
    }

    @Override
    public @NonNull StorageNBTComponent style(@NonNull Style style) {
        return new StorageNBTComponentImpl(this.children, style, this.nbtPath, this.interpret, this.storage);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StorageNBTComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        StorageNBTComponentImpl that = (StorageNBTComponentImpl)other;
        return Objects.equals(this.storage, that.storage());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.storage.hashCode();
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("storage", this.storage)), super.examinableProperties());
    }

    @Override
    public @NonNull StorageNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends NBTComponentImpl.BuilderImpl<StorageNBTComponent, StorageNBTComponent.Builder>
    implements StorageNBTComponent.Builder {
        private @MonotonicNonNull Key storage;

        BuilderImpl() {
        }

        BuilderImpl(@NonNull StorageNBTComponent component) {
            super(component);
            this.storage = component.storage();
        }

        @Override
        public @NonNull StorageNBTComponent.Builder storage(@NonNull Key storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public @NonNull StorageNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.storage == null) {
                throw new IllegalStateException("storage must be set");
            }
            return new StorageNBTComponentImpl(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.storage);
        }
    }
}

