/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions.types;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.types.ActionWithParameters;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.config.ConfigFileWithActions;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogAction
extends ActionWithParameters<ViolationData, ActionList> {
    public final boolean toChat;
    public final boolean toConsole;
    public final boolean toFile;

    public LogAction(String name, int delay, int repeat, boolean toChat, boolean toConsole, boolean toFile, String message) {
        super(name, delay, repeat, message);
        this.toChat = toChat;
        this.toConsole = toConsole;
        this.toFile = toFile;
    }

    @Override
    public Action<ViolationData, ActionList> getOptimizedCopy(ConfigFileWithActions<ViolationData, ActionList> config, Integer threshold) {
        if (!config.getBoolean("logging.active")) {
            return null;
        }
        return this;
    }

    @Override
    public boolean execute(ViolationData violationData) {
        if (!violationData.player.hasPermission(violationData.getPermissionSilent())) {
            String message = super.getMessage(violationData);
            LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
            if (this.toChat) {
                logManager.info(Streams.NOTIFY_INGAME, ColorUtil.replaceColors(message));
            }
            if (this.toConsole) {
                logManager.info(Streams.SERVER_LOGGER, ColorUtil.removeColors(message));
            }
            if (this.toFile) {
                logManager.info(Streams.DEFAULT_FILE, ColorUtil.removeColors(message));
            }
        }
        return false;
    }

    public String toString() {
        return "log:" + this.name + ":" + this.delay + ":" + this.repeat + ":" + (this.toConsole ? "c" : "") + (this.toChat ? "i" : "") + (this.toFile ? "f" : "");
    }
}

