/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class Against
extends Check {
    public Against() {
        super(CheckType.BLOCKPLACE_AGAINST);
    }

    public boolean check(Player player, Block block, Material placedMat, Block blockAgainst, BlockPlaceData data, BlockPlaceConfig cc) {
        boolean violation = false;
        Material againstType = blockAgainst.getType();
        if (BlockProperties.isAir(againstType)) {
            BlockInteractData bdata = BlockInteractData.getData(player);
            if (bdata.lastType != null && bdata.lastX != Integer.MAX_VALUE && (long)TickTask.getTick() == bdata.lastTick && TrigUtil.manhattan(bdata.lastX, bdata.lastY, bdata.lastZ, blockAgainst) == 0) {
                bdata.resetLastBlock();
                return false;
            }
        }
        if (BlockProperties.isLiquid(againstType)) {
            if (!(placedMat == Material.WATER_LILY && BlockProperties.isLiquid(block.getRelative(BlockFace.DOWN).getType()) || player.hasPermission("nocheatplus.checks.blockplace.against.liquids"))) {
                violation = true;
            }
        } else if (BlockProperties.isAir(againstType) && !player.hasPermission("nocheatplus.checks.blockplace.against.air")) {
            violation = true;
        }
        if (violation) {
            data.againstVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.againstVL, 1.0, cc.againstActions);
            vd.setParameter(ParameterName.BLOCK_TYPE, placedMat.toString());
            vd.setParameter(ParameterName.BLOCK_ID, Integer.toString(BlockProperties.getId(placedMat)));
            return this.executeActions(vd);
        }
        data.againstVL *= 0.99;
        return false;
    }
}

