/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.chat.Captcha;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.Color;
import fr.neatmonster.nocheatplus.checks.chat.Commands;
import fr.neatmonster.nocheatplus.checks.chat.Logins;
import fr.neatmonster.nocheatplus.checks.chat.Relog;
import fr.neatmonster.nocheatplus.checks.chat.Text;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ChatListener
extends CheckListener
implements INotifyReload,
JoinLeaveListener {
    private final Captcha captcha = this.addCheck(new Captcha());
    private final Color color = this.addCheck(new Color());
    private final Commands commands = this.addCheck(new Commands());
    private final Logins logins = this.addCheck(new Logins());
    private final Text text = this.addCheck(new Text());
    private final Relog relog = this.addCheck(new Relog());
    private final SimpleCharPrefixTree commandExclusions = new SimpleCharPrefixTree();
    private final SimpleCharPrefixTree chatCommands = new SimpleCharPrefixTree();
    private final SimpleCharPrefixTree consoleOnlyCommands = new SimpleCharPrefixTree();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public ChatListener() {
        super(CheckType.CHAT);
        ConfigFile config = ConfigManager.getConfigFile();
        this.initFilters(config);
    }

    private void initFilters(ConfigFile config) {
        CommandUtil.feedCommands(this.consoleOnlyCommands, config, "protection.commands.consoleonly.commands", true);
        CommandUtil.feedCommands(this.chatCommands, config, "checks.chat.commands.handleaschat", true);
        CommandUtil.feedCommands(this.commandExclusions, config, "checks.chat.commands.exclusions", true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        TickTask.requestPermissionUpdate(event.getPlayer().getName(), CheckType.CHAT);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        boolean alreadyCancelled = event.isCancelled();
        TickTask.requestPermissionUpdate(player.getName(), CheckType.CHAT);
        if (!alreadyCancelled && this.color.isEnabled(player)) {
            event.setMessage(this.color.check(player, event.getMessage(), false));
        }
        if (this.textChecks(player, event.getMessage(), false, alreadyCancelled)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        int index;
        Player player = event.getPlayer();
        TickTask.requestPermissionUpdate(player.getName(), CheckType.CHAT);
        ChatConfig cc = ChatConfig.getConfig(player);
        if (this.color.isEnabled(player)) {
            event.setMessage(this.color.check(player, event.getMessage(), true));
        }
        String message = event.getMessage();
        String lcMessage = StringUtil.leftTrim(message).toLowerCase();
        String[] split = lcMessage.split(" ", 2);
        String alias = split[0].substring(1);
        Command command = CommandUtil.getCommand(alias);
        ArrayList<String> messageVars = new ArrayList<String>();
        messageVars.add(lcMessage);
        String checkMessage = message;
        if (command != null) {
            messageVars.add("/" + command.getLabel().toLowerCase() + (split.length > 1 ? " " + split[1] : ""));
        }
        if (alias.indexOf(":") != -1 && (index = message.indexOf(":") + 1) < message.length()) {
            checkMessage = message.substring(index);
            messageVars.add(checkMessage.toLowerCase());
        }
        if (cc.consoleOnlyCheck && this.consoleOnlyCommands.hasAnyPrefixWords(messageVars)) {
            if (command == null || command.testPermission((CommandSender)player)) {
                player.sendMessage(cc.consoleOnlyMessage);
            }
            event.setCancelled(true);
            return;
        }
        if (this.chatCommands.hasAnyPrefixWords(messageVars)) {
            if (this.textChecks(player, checkMessage, true, false)) {
                event.setCancelled(true);
            }
        } else if (!this.commandExclusions.hasAnyPrefixWords(messageVars)) {
            if (this.commands.isEnabled(player) && this.commands.check(player, checkMessage, this.captcha)) {
                event.setCancelled(true);
            } else {
                MovingConfig mcc = MovingConfig.getConfig(player);
                if (mcc.passableUntrackedCommandCheck && mcc.passableUntrackedCommandPrefixes.hasAnyPrefix(messageVars) && this.checkUntrackedLocation(player, message, mcc)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    private boolean checkUntrackedLocation(Player player, String message, MovingConfig mcc) {
        Location newTo;
        Location loc = player.getLocation(this.useLoc);
        boolean cancel = false;
        if (MovingUtil.shouldCheckUntrackedLocation(player, loc) && (newTo = MovingUtil.checkUntrackedLocation(loc)) != null) {
            if (mcc.passableUntrackedCommandTryTeleport && player.teleport(newTo, PlayerTeleportEvent.TeleportCause.PLUGIN)) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.TRACE_FILE, player.getName() + " runs the command '" + message + "' at an untracked location: " + loc + " , teleport to: " + newTo);
            } else {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.TRACE_FILE, player.getName() + " runs the command '" + message + "' at an untracked location: " + loc + " , cancel the command.");
                cancel = true;
            }
        }
        this.useLoc.setWorld(null);
        return cancel;
    }

    private boolean textChecks(Player player, String message, boolean isMainThread, boolean alreadyCancelled) {
        return this.text.isEnabled(player) && this.text.check(player, message, this.captcha, isMainThread, alreadyCancelled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        Player player = event.getPlayer();
        ChatConfig cc = ChatConfig.getConfig(player);
        ChatData data = ChatData.getData(player);
        TickTask.requestPermissionUpdate(player.getName(), CheckType.CHAT);
        TickTask.updatePermissions();
        ChatData chatData = data;
        synchronized (chatData) {
            this.captcha.resetCaptcha(cc, data);
        }
        if (this.relog.isEnabled(player) && this.relog.unsafeLoginCheck(player, cc, data)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, cc.relogKickMessage);
        } else if (this.logins.isEnabled(player) && this.logins.check(player, cc, data)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, cc.loginsKickMessage);
        }
    }

    public void onReload() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.initFilters(config);
        this.text.onReload();
        this.logins.onReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerJoins(Player player) {
        ChatData data;
        ChatConfig cc = ChatConfig.getConfig(player);
        ChatData chatData = data = ChatData.getData(player);
        synchronized (chatData) {
            if (this.captcha.isEnabled(player) && this.captcha.shouldCheckCaptcha(cc, data)) {
                this.captcha.sendNewCaptcha(player, cc, data);
            }
        }
    }

    public void playerLeaves(Player player) {
    }
}

