/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.combined;

import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.entity.Player;

public class Combined {
    private static float stationary = 32.0f;

    public static final boolean checkYawRate(Player player, float yaw, long now, String worldName) {
        return Combined.checkYawRate(player, yaw, now, worldName, CombinedData.getData(player));
    }

    public static final void feedYawRate(Player player, float yaw, long now, String worldName) {
        Combined.feedYawRate(player, yaw, now, worldName, CombinedData.getData(player));
    }

    public static final void feedYawRate(Player player, float yaw, long now, String worldName, CombinedData data) {
        float yawDiff;
        if (yaw <= -360.0f) {
            yaw = -(-yaw % 360.0f);
        } else if (yaw >= 360.0f) {
            yaw %= 360.0f;
        }
        if (now - data.lastYawTime > 999L || !worldName.equals(data.lastWorld)) {
            data.lastYaw = yaw;
            data.sumYaw = 0.0f;
            data.lastYawTime = now;
            data.lastWorld = worldName;
        }
        if ((yawDiff = data.lastYaw - yaw) < -180.0f) {
            yawDiff += 360.0f;
        } else if (yawDiff > 180.0f) {
            yawDiff -= 360.0f;
        }
        long elapsed = now - data.lastYawTime;
        data.lastYaw = yaw;
        data.lastYawTime = now;
        float dAbs = Math.abs(yawDiff);
        if (dAbs < stationary) {
            data.sumYaw += yawDiff;
            if (Math.abs(data.sumYaw) < stationary) {
                data.yawFreq.update(now);
                return;
            }
            data.sumYaw = 0.0f;
        } else {
            data.sumYaw = 0.0f;
        }
        float dNorm = dAbs / (float)(1L + elapsed);
        data.yawFreq.add(now, dNorm);
    }

    public static final boolean checkYawRate(Player player, float yaw, long now, String worldName, CombinedData data) {
        Combined.feedYawRate(player, yaw, now, worldName, data);
        CombinedConfig cc = CombinedConfig.getConfig(player);
        float threshold = cc.yawRate;
        float stScore = data.yawFreq.bucketScore(0) * 3.0f;
        float stViol = stScore > threshold ? (!cc.lag || (double)TickTask.getLag(data.yawFreq.bucketDuration(), true) < 1.2 ? stScore : 0.0f) : 0.0f;
        float fullScore = data.yawFreq.score(1.0f);
        float fullViol = fullScore > threshold ? (cc.lag ? fullScore / TickTask.getLag(data.yawFreq.bucketDuration() * (long)data.yawFreq.numberOfBuckets(), true) : fullScore) : 0.0f;
        float total = Math.max(stViol, fullViol);
        boolean cancel = false;
        if (total > threshold) {
            float amount = (total - threshold) / threshold * 1000.0f;
            data.timeFreeze.applyPenalty(now, (long)Math.min(Math.max(cc.yawRatePenaltyFactor * amount, (float)cc.yawRatePenaltyMin), (float)cc.yawRatePenaltyMax));
            if (cc.yawRateImprobable && Improbable.check(player, amount / 100.0f, now, "combined.yawrate")) {
                cancel = true;
            }
        }
        if (data.timeFreeze.isPenalty()) {
            cancel = true;
        }
        return cancel;
    }

    public static final void resetYawRate(Player player, float yaw, long time, boolean clear) {
        if (yaw <= -360.0f) {
            yaw = -(-yaw % 360.0f);
        } else if (yaw >= 360.0f) {
            yaw %= 360.0f;
        }
        CombinedData data = CombinedData.getData(player);
        data.lastYaw = yaw;
        data.lastYawTime = time;
        data.sumYaw = 0.0f;
        if (clear) {
            data.yawFreq.clear(time);
        }
    }

    public static final boolean checkYawRate(Player player, float yaw, long now, String worldName, boolean yawRateCheck) {
        if (yawRateCheck) {
            return Combined.checkYawRate(player, yaw, now, worldName);
        }
        Combined.feedYawRate(player, yaw, now, worldName);
        return false;
    }
}

