/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.access.SubCheckDataFactory;
import fr.neatmonster.nocheatplus.checks.fight.Angle;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.hooks.APIUtils;
import fr.neatmonster.nocheatplus.utilities.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.PenaltyTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.entity.Player;

public class FightData
extends ACheckData {
    public static final CheckDataFactory factory = new FightDataFactory();
    public static final CheckDataFactory selfHitDataFactory = new SubCheckDataFactory<FightData>(CheckType.FIGHT, factory){

        @Override
        protected FightData getData(String playerName) {
            return playersMap.get(playerName);
        }

        @Override
        protected Collection<String> getPresentData() {
            return playersMap.keySet();
        }

        @Override
        protected boolean hasData(String playerName) {
            return playersMap.containsKey(playerName);
        }

        @Override
        protected boolean removeFromData(String playerName, FightData data) {
            if (data.selfHitVL.score(1.0f) > 0.0f) {
                data.selfHitVL.clear(System.currentTimeMillis());
                return true;
            }
            return false;
        }
    };
    protected static final Map<String, FightData> playersMap = new HashMap<String, FightData>();
    public double angleVL;
    public double criticalVL;
    public double directionVL;
    public double fastHealVL;
    public double godModeVL;
    public double noSwingVL;
    public double reachVL;
    public double speedVL;
    public String lastWorld = "";
    public int lastAttackTick = 0;
    public double lastAttackedX = Double.MAX_VALUE;
    public double lastAttackedY;
    public double lastAttackedZ;
    public final PenaltyTime attackPenalty = new PenaltyTime();
    public int thornsId = Integer.MIN_VALUE;
    public long regainHealthTime = 0L;
    public long damageTakenByEntityTick;
    public LinkedList<Angle.AttackLocation> angleHits = new LinkedList();
    public long fastHealRefTime = 0L;
    public long fastHealBuffer = 0L;
    public int godModeBuffer;
    public int godModeLastAge;
    public long godModeLastTime;
    public int godModeHealthDecreaseTick = 0;
    public double godModeHealth = 0.0;
    public int lastDamageTick = 0;
    public int lastNoDamageTicks = 0;
    public int godModeAcc = 0;
    public boolean noSwingArmSwung;
    public double reachMod = 1.0;
    public ActionFrequency selfHitVL = new ActionFrequency(6, 5000L);
    public final ActionFrequency speedBuckets;
    public int speedShortTermCount;
    public int speedShortTermTick;
    public int lastExplosionDamageTick = -1;
    public int lastExplosionEntityId = Integer.MAX_VALUE;

    public static CheckDataFactory getCheckDataFactory(CheckType checkType) {
        if (checkType != CheckType.FIGHT && !APIUtils.isParent(CheckType.FIGHT, checkType)) {
            throw new IllegalArgumentException("Can only return a CheckDataFactory for the check group FIGHT.");
        }
        switch (checkType) {
            case FIGHT_SELFHIT: {
                return selfHitDataFactory;
            }
        }
        return factory;
    }

    public static FightData getData(Player player) {
        if (!playersMap.containsKey(player.getName())) {
            playersMap.put(player.getName(), new FightData(FightConfig.getConfig(player)));
        }
        return playersMap.get(player.getName());
    }

    public static ICheckData removeData(String playerName) {
        return playersMap.remove(playerName);
    }

    public static void clear() {
        playersMap.clear();
    }

    public FightData(FightConfig config) {
        super(config);
        this.speedBuckets = new ActionFrequency(config.speedBuckets, config.speedBucketDur);
        this.fastHealBuffer = config.fastHealBuffer;
    }

    public void onWorldChange() {
        this.angleHits.clear();
        this.lastAttackedX = Double.MAX_VALUE;
        this.lastAttackTick = 0;
        this.lastWorld = "";
    }

    public static class FightDataFactory
    implements CheckDataFactory {
        protected FightDataFactory() {
        }

        public final ICheckData getData(Player player) {
            return FightData.getData(player);
        }

        public ICheckData removeData(String playerName) {
            return FightData.removeData(playerName);
        }

        public void removeAllData() {
            FightData.clear();
        }
    }
}

