/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class InstantBow
extends Check {
    private static final float maxTime = 800.0f;

    public InstantBow() {
        super(CheckType.INVENTORY_INSTANTBOW);
    }

    public boolean check(Player player, float force, long now) {
        long pullDuration;
        boolean valid;
        InventoryData data = InventoryData.getData(player);
        InventoryConfig cc = InventoryConfig.getConfig(player);
        boolean cancel = false;
        long expectedPullDuration = (long)(800.0f - 800.0f * (1.0f - force) * (1.0f - force)) - cc.instantBowDelay;
        if (cc.instantBowStrict) {
            valid = data.instantBowInteract != 0L;
            pullDuration = valid ? now - data.instantBowInteract : 0L;
        } else {
            valid = true;
            pullDuration = now - data.instantBowShoot;
        }
        if (valid && (!cc.instantBowStrict || data.instantBowInteract > 0L) && pullDuration >= expectedPullDuration) {
            data.instantBowVL *= 0.9;
        } else if (!valid || data.instantBowInteract <= now) {
            long correctedPullduration;
            long l = valid ? (cc.lag ? (long)(TickTask.getLag(expectedPullDuration, true) * (float)pullDuration) : pullDuration) : (correctedPullduration = 0L);
            if (correctedPullduration < expectedPullDuration) {
                double difference = (double)(expectedPullDuration - pullDuration) / 100.0;
                data.instantBowVL += difference;
                cancel = this.executeActions(player, data.instantBowVL, difference, cc.instantBowActions);
            }
        }
        if (data.debug && player.hasPermission("nocheatplus.admin.debug")) {
            player.sendMessage(ChatColor.YELLOW + "NCP: " + ChatColor.GRAY + "Bow shot - force: " + force + ", " + (cc.instantBowStrict || pullDuration < 2L * expectedPullDuration ? "pull time: " + pullDuration : "") + "(" + expectedPullDuration + ")");
        }
        data.instantBowInteract = 0L;
        data.instantBowShoot = now;
        return cancel;
    }
}

