/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class CreativeFly
extends Check {
    public CreativeFly() {
        super(CheckType.MOVING_CREATIVEFLY);
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MoveData moveData, MovingData data, MovingConfig cc, long time) {
        double limitH;
        double resultH;
        boolean flying;
        if (!data.hasSetBack()) {
            data.setSetBack(from);
        }
        GameMode gameMode = player.getGameMode();
        ModelFlying model = cc.flyingModels.get(gameMode);
        double maximumHeight = model.maxHeight + (double)player.getWorld().getMaxHeight();
        if (to.getY() > maximumHeight) {
            return new Location(player.getWorld(), data.getSetBackX(), Math.max(maximumHeight - 10.0, (double)to.getWorld().getMaxHeight()), data.getSetBackZ(), to.getYaw(), to.getPitch());
        }
        double yDistance = moveData.yDistance;
        double hDistance = moveData.hDistance;
        boolean sprinting = time <= data.timeSprinting + cc.sprintingGrace;
        double speedModifier = this.mcAccess.getFasterMovementAmplifier(player);
        double fSpeed = speedModifier == Double.NEGATIVE_INFINITY ? 1.0 : 1.0 + 0.2 * (speedModifier + 1.0);
        boolean bl = flying = gameMode == BridgeMisc.GAME_MODE_SPECTATOR || player.isFlying();
        if (flying) {
            fSpeed *= (double)data.flySpeed / 0.1;
            if (sprinting) {
                fSpeed *= model.hModSprint;
            }
        } else {
            fSpeed *= (double)data.walkSpeed / 0.2;
        }
        if ((resultH = Math.max(0.0, hDistance - (limitH = model.hMod / 100.0 * 0.6 * fSpeed))) > 0.0) {
            double hFreedom = data.getHorizontalFreedom();
            if (hFreedom < resultH) {
                hFreedom += data.useHorizontalVelocity(resultH - hFreedom);
            }
            if (hFreedom > 0.0) {
                resultH = Math.max(0.0, resultH - hFreedom);
            }
        } else {
            data.clearActiveHorVel();
        }
        --data.bunnyhopDelay;
        if (!flying && resultH > 0.0 && sprinting && data.bunnyhopDelay <= 0 && resultH < 0.4) {
            data.bunnyhopDelay = 9;
            resultH = 0.0;
        }
        resultH *= 100.0;
        double limitV = model.vMod / 100.0 * 1.0;
        if (data.lastYDist != Double.MAX_VALUE) {
            double frictionDist = data.lastYDist * 0.98;
            if (!flying) {
                frictionDist -= 0.0624;
            }
            limitV = Math.max(frictionDist, limitV);
        }
        double resultV = yDistance > limitV && data.getOrUseVerticalVelocity(yDistance) != null ? 0.0 : (yDistance - limitV) * 100.0;
        double result = Math.max(0.0, resultH) + Math.max(0.0, resultV);
        if (data.debug) {
            this.outpuDebugMove(player, hDistance, limitH, yDistance, limitV, data);
        }
        if (result > 0.0) {
            if (data.creativeFlyPreviousRefused) {
                data.creativeFlyVL += result;
                ViolationData vd = new ViolationData(this, player, data.creativeFlyVL, result, cc.creativeFlyActions);
                if (vd.needsParameters()) {
                    vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
                    vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
                    vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
                }
                if (this.executeActions(vd)) {
                    return data.getSetBack(to);
                }
            } else {
                data.creativeFlyPreviousRefused = true;
            }
        } else {
            data.creativeFlyPreviousRefused = false;
        }
        data.creativeFlyVL *= 0.97;
        data.setSetBack(to);
        return null;
    }

    private void outpuDebugMove(Player player, double hDistance, double limitH, double yDistance, double limitV, MovingData data) {
        StringBuilder builder = new StringBuilder(350);
        builder.append(player.getName());
        builder.append(" CreativeFly hdist=" + hDistance + " hlimit=" + limitH + " ydist=" + yDistance + " vlimit=" + limitV);
        if (data.verVelUsed != null) {
            builder.append(" vvel_use=" + data.verVelUsed);
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }
}

