/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.model;

import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TeleportQueue {
    private final Lock lock = new ReentrantLock();
    private DataPacketFlying lastTeleport = null;
    private DataPacketFlying expectTeleport = null;

    public void onTeleportEvent(DataPacketFlying packetData) {
        this.lock.lock();
        this.expectTeleport = packetData;
        this.lock.unlock();
    }

    public DataPacketFlying onOutgoingTeleport(double x, double y, double z, float yaw, float pitch) {
        DataPacketFlying res = null;
        this.lock.lock();
        if (this.expectTeleport != null && this.expectTeleport.matches(x, y, z, yaw, pitch)) {
            res = this.expectTeleport;
            this.lastTeleport = this.expectTeleport;
            this.expectTeleport = null;
        }
        this.lock.unlock();
        return res;
    }

    public AckResolution processAck(DataPacketFlying packetData) {
        AckResolution res;
        this.lock.lock();
        if (this.lastTeleport == null) {
            res = AckResolution.IDLE;
        } else if (packetData.containsSameLocation(this.lastTeleport)) {
            this.lastTeleport = null;
            res = AckResolution.ACK;
        } else if (packetData.time - this.lastTeleport.time > 15000L || packetData.time < this.lastTeleport.time) {
            this.lastTeleport = null;
            res = AckResolution.IDLE;
        } else {
            res = AckResolution.CANCEL;
        }
        this.lock.unlock();
        return res;
    }

    public void clear() {
        this.lock.lock();
        this.lastTeleport = null;
        this.expectTeleport = null;
        this.lock.unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AckResolution {
        CANCEL,
        ACK,
        IDLE;

    }
}

