/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.protocollib.AttackFrequency;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UseEntityAdapter
extends BaseAdapter {
    private final AttackFrequency attackFrequency;

    public UseEntityAdapter(Plugin plugin) {
        super(plugin, PacketType.Play.Client.USE_ENTITY);
        if (ConfigManager.isTrueForAnyConfig("checks.net.attackfrequency.active")) {
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(AttackFrequency.class.getSimpleName()));
        }
        this.attackFrequency = new AttackFrequency();
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.attackFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        NetConfig cc = this.configFactory.getConfig(player);
        NetData data = this.dataFactory.getData(player);
        data.lastKeepAliveTime = time;
        if (!cc.attackFrequencyActive) {
            return;
        }
        PacketContainer packet = event.getPacket();
        StructureModifier actions = packet.getEntityUseActions();
        if (actions.size() != 1) {
            return;
        }
        EnumWrappers.EntityUseAction action = (EnumWrappers.EntityUseAction)actions.read(0);
        boolean cancel = false;
        if (action == EnumWrappers.EntityUseAction.ATTACK && this.attackFrequency.isEnabled(player, data, cc) && this.attackFrequency.check(player, time, data, cc)) {
            cancel = true;
        }
        if (cancel) {
            event.setCancelled(true);
        }
    }
}

