/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.init;

import fr.neatmonster.nocheatplus.utilities.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import org.bukkit.Material;

public class BlockInit {
    public static void assertMaterialExists(int id) {
        if (BlockProperties.getMaterial(id) == null) {
            throw new RuntimeException("Material " + id + " does not exist.");
        }
    }

    public static void assertMaterialName(int id, String name) {
        Material mat = BlockProperties.getMaterial(id);
        if (mat == null) {
            throw new RuntimeException("Material " + id + " does not exist.");
        }
        if (mat.name().equals(name)) {
            throw new RuntimeException("Name for Material " + id + " ('" + mat.name() + "') does not match '" + name + "'.");
        }
    }

    public static void assertMaterialNameMatch(int id, String ... parts) {
        Material mat = BlockProperties.getMaterial(id);
        if (mat == null) {
            throw new RuntimeException("Material " + id + " does not exist.");
        }
        String name = mat.name().toLowerCase();
        for (String part : parts) {
            if (name.indexOf(part.toLowerCase()) >= 0) continue;
            throw new RuntimeException("Name for Material " + id + " ('" + mat.name() + "') should contain '" + part + "'.");
        }
    }

    public static void setPropsAs(int newId, Material mat) {
        BlockProperties.setBlockProps(newId, BlockProperties.getBlockProps(mat));
    }

    public static void setPropsAs(int newId, int otherId) {
        BlockProperties.setBlockProps(newId, BlockProperties.getBlockProps(otherId));
    }

    public static void setAs(int newId, Material mat) {
        BlockFlags.setFlagsAs(newId, mat);
        BlockInit.setPropsAs(newId, mat);
    }

    public static void setAs(int newId, int otherId) {
        BlockFlags.setFlagsAs(newId, otherId);
        BlockInit.setPropsAs(newId, otherId);
    }

    public static void setInstantAir(int newId) {
        BlockFlags.setFlagsAs(newId, Material.AIR);
        BlockProperties.setBlockProps(newId, BlockProperties.instantType);
    }
}

