/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cb2808;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.cb2808.BlockCacheCB2808;
import fr.neatmonster.nocheatplus.utilities.AttribUtil;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import net.minecraft.server.v1_6_R2.AttributeInstance;
import net.minecraft.server.v1_6_R2.AttributeModifier;
import net.minecraft.server.v1_6_R2.AxisAlignedBB;
import net.minecraft.server.v1_6_R2.Block;
import net.minecraft.server.v1_6_R2.DamageSource;
import net.minecraft.server.v1_6_R2.EntityComplexPart;
import net.minecraft.server.v1_6_R2.EntityPlayer;
import net.minecraft.server.v1_6_R2.GenericAttributes;
import net.minecraft.server.v1_6_R2.MobEffectList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_6_R2.CraftServer;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_6_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCAccessCB2808
implements MCAccess {
    public MCAccessCB2808() {
        this.getCommandMap();
        ReflectionUtil.checkMembers("net.minecraft.server.v1_6_R2.", new String[][]{{"Entity", "dead"}});
        ReflectionUtil.checkMethodReturnTypesNoArgs(Block.class, new String[]{"u", "v", "w", "x", "y", "z"}, Double.TYPE);
    }

    public String getMCVersion() {
        return "1.6.2";
    }

    public String getServerVersionTag() {
        return "CB2808";
    }

    public CommandMap getCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public BlockCache getBlockCache(World world) {
        return new BlockCacheCB2808(world);
    }

    public double getHeight(Entity entity) {
        net.minecraft.server.v1_6_R2.Entity mcEntity = ((CraftEntity)entity).getHandle();
        double entityHeight = Math.max((double)mcEntity.length, Math.max((double)mcEntity.height, mcEntity.boundingBox.e - mcEntity.boundingBox.b));
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    public AlmostBoolean isBlockSolid(int id) {
        Block block = Block.byId[id];
        if (block == null || block.material == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.material.isSolid());
    }

    public AlmostBoolean isBlockLiquid(int id) {
        Block block = Block.byId[id];
        if (block == null || block.material == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.material.isLiquid());
    }

    public double getWidth(Entity entity) {
        return ((CraftEntity)entity).getHandle().width;
    }

    public AlmostBoolean isIllegalBounds(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.dead) {
            return AlmostBoolean.NO;
        }
        AxisAlignedBB box = entityPlayer.boundingBox;
        if (!entityPlayer.isSleeping()) {
            double dY = Math.abs(box.e - box.b);
            if (dY > 1.8) {
                return AlmostBoolean.YES;
            }
            if (dY < 0.1 && (double)entityPlayer.length >= 0.1) {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.MAYBE;
    }

    public double getJumpAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.JUMP)) {
            return mcPlayer.getEffect(MobEffectList.JUMP).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getFasterMovementAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            return mcPlayer.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getSpeedAttributeMultiplier(Player player) {
        AttributeInstance attr = ((CraftLivingEntity)player).getHandle().getAttributeInstance(GenericAttributes.d);
        double val = attr.getValue() / attr.b();
        AttributeModifier mod = attr.a(AttribUtil.ID_SPRINT_BOOST);
        if (mod == null) {
            return val;
        }
        return val / AttribUtil.getMultiplier(mod.c(), mod.d());
    }

    public double getSprintAttributeMultiplier(Player player) {
        AttributeModifier mod = ((CraftLivingEntity)player).getHandle().getAttributeInstance(GenericAttributes.d).a(AttribUtil.ID_SPRINT_BOOST);
        if (mod == null) {
            return 1.0;
        }
        return AttribUtil.getMultiplier(mod.c(), mod.d());
    }

    public int getInvulnerableTicks(Player player) {
        return ((CraftPlayer)player).getHandle().invulnerableTicks;
    }

    public void setInvulnerableTicks(Player player, int ticks) {
        ((CraftPlayer)player).getHandle().invulnerableTicks = ticks;
    }

    public void dealFallDamage(Player player, double damage) {
        ((CraftPlayer)player).getHandle().damageEntity(DamageSource.FALL, (float)damage);
    }

    public boolean isComplexPart(Entity entity) {
        return ((CraftEntity)entity).getHandle() instanceof EntityComplexPart;
    }

    public boolean shouldBeZombie(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        return !mcPlayer.dead && mcPlayer.getHealth() <= 0.0f;
    }

    public void setDead(Player player, int deathTicks) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        mcPlayer.deathTicks = deathTicks;
        mcPlayer.dead = true;
    }

    public boolean hasGravity(Material mat) {
        return mat.hasGravity();
    }

    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.NO;
    }
}

