/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect.reflect;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectAttributeInstance;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectAttributeModifier;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBase;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlock;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlockPosition;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectDamageSource;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectEntity;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectGenericAttributes;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectMaterial;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectPlayer;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectWorld;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.AttribUtil;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.lang.reflect.Field;
import java.util.LinkedList;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ReflectHelper {
    protected final ReflectBase reflectBase;
    protected final ReflectBlockPosition reflectBlockPosition;
    protected final ReflectBlock reflectBlock;
    protected final ReflectMaterial reflectMaterial;
    protected final ReflectWorld reflectWorld;
    protected final ReflectDamageSource reflectDamageSource;
    protected final ReflectEntity reflectEntity;
    protected final ReflectPlayer reflectPlayer;
    protected final ReflectGenericAttributes reflectGenericAttributes;
    protected final ReflectAttributeInstance reflectAttributeInstance;
    protected final ReflectAttributeModifier reflectAttributeModifier;
    protected final boolean hasAttributes;

    public ReflectHelper() throws ReflectFailureException {
        try {
            this.reflectBase = new ReflectBase();
            ReflectBlockPosition reflectBlockPosition = null;
            try {
                reflectBlockPosition = new ReflectBlockPosition(this.reflectBase);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            this.reflectBlockPosition = reflectBlockPosition;
            this.reflectBlock = new ReflectBlock(this.reflectBase, this.reflectBlockPosition);
            this.reflectMaterial = new ReflectMaterial(this.reflectBase);
            this.reflectWorld = new ReflectWorld(this.reflectBase);
            this.reflectDamageSource = new ReflectDamageSource(this.reflectBase);
            this.reflectEntity = new ReflectEntity(this.reflectBase, this.reflectDamageSource);
            this.reflectPlayer = new ReflectPlayer(this.reflectBase, this.reflectDamageSource);
            ReflectGenericAttributes reflectGenericAttributes = null;
            ReflectAttributeInstance reflectAttributeInstance = null;
            ReflectAttributeModifier reflectAttributeModifier = null;
            boolean hasAttributes = false;
            try {
                reflectGenericAttributes = new ReflectGenericAttributes(this.reflectBase);
                reflectAttributeInstance = new ReflectAttributeInstance(this.reflectBase);
                reflectAttributeModifier = new ReflectAttributeModifier(this.reflectBase);
                hasAttributes = true;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            this.reflectGenericAttributes = reflectGenericAttributes;
            this.reflectAttributeInstance = reflectAttributeInstance;
            this.reflectAttributeModifier = reflectAttributeModifier;
            this.hasAttributes = hasAttributes;
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectFailureException(ex);
        }
        if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
            LinkedList<String> parts = new LinkedList<String>();
            for (Field rootField : this.getClass().getDeclaredFields()) {
                Object obj;
                boolean accessible = rootField.isAccessible();
                if (!accessible) {
                    rootField.setAccessible(true);
                }
                if ((obj = ReflectionUtil.get(rootField, this, null)) == null) {
                    parts.add("(Not available: " + rootField.getName() + ")");
                    continue;
                }
                if (rootField.getName().startsWith("reflect")) {
                    Class<?> clazz = obj.getClass();
                    for (Field field : clazz.getFields()) {
                        if (ReflectionUtil.get(field, obj, null) != null) continue;
                        parts.add(clazz.getName() + "." + field.getName());
                    }
                }
                if (accessible) continue;
                rootField.setAccessible(false);
            }
            if (!parts.isEmpty()) {
                parts.add(0, "CompatCBReflect: The following properties could not be set:");
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, StringUtil.join(parts, "\n"));
            }
        }
    }

    private void fail() {
        throw new ReflectFailureException();
    }

    public Object getHandle(Player player) {
        Object handle;
        if (this.reflectPlayer.obcGetHandle == null) {
            this.fail();
        }
        if ((handle = ReflectionUtil.invokeMethodNoArgs(this.reflectPlayer.obcGetHandle, player)) == null) {
            this.fail();
        }
        return handle;
    }

    public double nmsPlayer_getHealth(Object handle) {
        if (this.reflectPlayer.nmsGetHealth == null) {
            this.fail();
        }
        return ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectPlayer.nmsGetHealth, handle)).doubleValue();
    }

    public boolean nmsPlayer_dead(Object handle) {
        if (this.reflectPlayer.nmsDead == null) {
            this.fail();
        }
        return ReflectionUtil.getBoolean(this.reflectPlayer.nmsDead, handle, true);
    }

    public void nmsPlayer_dead(Object handle, boolean value) {
        if (this.reflectPlayer.nmsDead == null || !ReflectionUtil.set(this.reflectPlayer.nmsDead, handle, value)) {
            this.fail();
        }
    }

    public void nmsPlayer_deathTicks(Object handle, int value) {
        if (this.reflectPlayer.nmsDeathTicks == null || !ReflectionUtil.set(this.reflectPlayer.nmsDeathTicks, handle, value)) {
            this.fail();
        }
    }

    public boolean canDealFallDamage() {
        return this.reflectPlayer.nmsDamageEntity != null && this.reflectDamageSource.nmsFALL != null;
    }

    public void dealFallDamage(Player player, double damage) {
        if (this.reflectDamageSource.nmsFALL == null) {
            this.fail();
        }
        Object handle = this.getHandle(player);
        this.nmsPlayer_dealDamage(handle, this.reflectDamageSource.nmsFALL, damage);
    }

    public void nmsPlayer_dealDamage(Object handle, Object damage_source, double damage) {
        if (this.reflectPlayer.nmsDamageEntity == null) {
            this.fail();
        }
        if (this.reflectPlayer.nmsDamageEntityInt) {
            ReflectionUtil.invokeMethod(this.reflectPlayer.nmsDamageEntity, handle, damage_source, (int)damage);
        } else {
            ReflectionUtil.invokeMethod(this.reflectPlayer.nmsDamageEntity, handle, damage_source, Float.valueOf((float)damage));
        }
    }

    public int getInvulnerableTicks(Player player) {
        if (this.reflectPlayer.nmsInvulnerableTicks == null) {
            this.fail();
        }
        Object handle = this.getHandle(player);
        return ReflectionUtil.getInt(this.reflectPlayer.nmsInvulnerableTicks, handle, player.getNoDamageTicks() / 2);
    }

    public void setInvulnerableTicks(Player player, int ticks) {
        Object handle;
        if (this.reflectPlayer.nmsInvulnerableTicks == null) {
            this.fail();
        }
        if (!ReflectionUtil.set(this.reflectPlayer.nmsInvulnerableTicks, handle = this.getHandle(player), ticks)) {
            this.fail();
        }
    }

    public Object getMovementSpeedAttributeInstance(Player player) {
        if (!this.hasAttributes || this.reflectPlayer.nmsGetAttributeInstance == null || this.reflectGenericAttributes.nmsMOVEMENT_SPEED == null) {
            this.fail();
        }
        return ReflectionUtil.invokeMethod(this.reflectPlayer.nmsGetAttributeInstance, this.getHandle(player), this.reflectGenericAttributes.nmsMOVEMENT_SPEED);
    }

    public double getSpeedAttributeMultiplier(Player player, boolean removeSprint) {
        if (!this.hasAttributes || this.reflectAttributeInstance.nmsGetValue == null || this.reflectAttributeInstance.nmsGetBaseValue == null) {
            this.fail();
        }
        Object attributeInstance = this.getMovementSpeedAttributeInstance(player);
        double val = (Double)ReflectionUtil.invokeMethodNoArgs(this.reflectAttributeInstance.nmsGetValue, attributeInstance) / (Double)ReflectionUtil.invokeMethodNoArgs(this.reflectAttributeInstance.nmsGetBaseValue, attributeInstance);
        if (!removeSprint) {
            return val;
        }
        return val / this.nmsAttributeInstance_getAttributeModifierMultiplier(attributeInstance);
    }

    public double getSprintAttributeMultiplier(Player player) {
        Object attributeInstance;
        if (!this.hasAttributes || this.reflectAttributeModifier.nmsGetOperation == null || this.reflectAttributeModifier.nmsGetValue == null) {
            this.fail();
        }
        if ((attributeInstance = this.getMovementSpeedAttributeInstance(player)) == null) {
            this.fail();
        }
        return this.nmsAttributeInstance_getAttributeModifierMultiplier(attributeInstance);
    }

    public double nmsAttributeInstance_getAttributeModifierMultiplier(Object attributeInstance) {
        Object mod;
        if (this.reflectAttributeInstance.nmsGetAttributeModifier == null) {
            this.fail();
        }
        if ((mod = ReflectionUtil.invokeMethod(this.reflectAttributeInstance.nmsGetAttributeModifier, attributeInstance, AttribUtil.ID_SPRINT_BOOST)) == null) {
            return 1.0;
        }
        return AttribUtil.getMultiplier((Integer)ReflectionUtil.invokeMethodNoArgs(this.reflectAttributeModifier.nmsGetOperation, mod), (Double)ReflectionUtil.invokeMethodNoArgs(this.reflectAttributeModifier.nmsGetValue, mod));
    }

    public Object getHandle(World world) {
        Object handle;
        if (this.reflectWorld.obcGetHandle == null) {
            this.fail();
        }
        if ((handle = ReflectionUtil.invokeMethodNoArgs(this.reflectWorld.obcGetHandle, world)) == null) {
            this.fail();
        }
        return handle;
    }

    public Object nmsBlockPosition(int x, int y, int z) {
        Object blockPos;
        if (!this.reflectBlock.useBlockPosition || this.reflectBlockPosition.new_nmsBlockPosition == null) {
            this.fail();
        }
        if ((blockPos = ReflectionUtil.newInstance(this.reflectBlockPosition.new_nmsBlockPosition, x, y, z)) == null) {
            this.fail();
        }
        return blockPos;
    }

    public Object nmsBlock_getById(int id) {
        if (this.reflectBlock.nmsGetById == null) {
            this.fail();
        }
        return ReflectionUtil.invokeMethod(this.reflectBlock.nmsGetById, null, id);
    }

    public Object nmsBlock_getMaterial(Object block) {
        if (this.reflectBlock.nmsGetMaterial == null) {
            this.fail();
        }
        return ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMaterial, block);
    }

    public void nmsBlock_updateShape(Object block, Object iBlockAccess, int x, int y, int z) {
        if (this.reflectBlock.nmsUpdateShape == null) {
            this.fail();
        }
        if (this.reflectBlock.useBlockPosition) {
            ReflectionUtil.invokeMethod(this.reflectBlock.nmsUpdateShape, block, iBlockAccess, this.nmsBlockPosition(x, y, z));
        } else {
            ReflectionUtil.invokeMethod(this.reflectBlock.nmsUpdateShape, block, iBlockAccess, x, y, z);
        }
    }

    public boolean nmsMaterial_isSolid(Object material) {
        if (this.reflectMaterial.nmsIsSolid == null) {
            this.fail();
        }
        return (Boolean)ReflectionUtil.invokeMethodNoArgs(this.reflectMaterial.nmsIsSolid, material);
    }

    public boolean nmsMaterial_isLiquid(Object material) {
        if (this.reflectMaterial.nmsIsLiquid == null) {
            this.fail();
        }
        return (Boolean)ReflectionUtil.invokeMethodNoArgs(this.reflectMaterial.nmsIsLiquid, material);
    }

    public AlmostBoolean isBlockSolid(int id) {
        Object obj = this.nmsBlock_getById(id);
        if (obj == null) {
            return AlmostBoolean.MAYBE;
        }
        if ((obj = this.nmsBlock_getMaterial(obj)) == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(this.nmsMaterial_isSolid(obj));
    }

    public AlmostBoolean isBlockLiquid(int id) {
        Object obj = this.nmsBlock_getById(id);
        if (obj == null) {
            return AlmostBoolean.MAYBE;
        }
        if ((obj = this.nmsBlock_getMaterial(obj)) == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(this.nmsMaterial_isLiquid(obj));
    }

    public double[] nmsWorld_fetchBlockShape(Object nmsWorld, int id, int x, int y, int z) {
        Object block;
        if (this.reflectBlock.nmsGetMinX == null) {
            this.fail();
        }
        if ((block = this.nmsBlock_getById(id)) == null) {
            return null;
        }
        this.nmsBlock_updateShape(block, nmsWorld, x, y, z);
        return new double[]{((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMinX, block)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMinY, block)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMinZ, block)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMaxX, block)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMaxY, block)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectBlock.nmsGetMaxZ, block)).doubleValue()};
    }

    public static class ReflectFailureException
    extends RuntimeException {
        private static final long serialVersionUID = -3934791920291782604L;

        public ReflectFailureException() {
        }

        public ReflectFailureException(ClassNotFoundException ex) {
            super(ex);
        }
    }
}

