/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.spigotcb1_8_R1;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.spigotcb1_8_R1.BlockCacheSpigotCB1_8_R1;
import fr.neatmonster.nocheatplus.utilities.AttribUtil;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import net.minecraft.server.v1_8_R1.AttributeInstance;
import net.minecraft.server.v1_8_R1.AttributeModifier;
import net.minecraft.server.v1_8_R1.AxisAlignedBB;
import net.minecraft.server.v1_8_R1.Block;
import net.minecraft.server.v1_8_R1.DamageSource;
import net.minecraft.server.v1_8_R1.EntityComplexPart;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.GenericAttributes;
import net.minecraft.server.v1_8_R1.MobEffectList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_8_R1.CraftServer;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCAccessSpigotCB1_8_R1
implements MCAccess {
    public MCAccessSpigotCB1_8_R1() {
        this.getCommandMap();
        ReflectionUtil.checkMembers("net.minecraft.server.v1_8_R1.", new String[][]{{"Entity", "dead"}});
        ReflectionUtil.checkMethodReturnTypesNoArgs(Block.class, new String[]{"z", "A", "B", "C", "D", "E"}, Double.TYPE);
    }

    public String getMCVersion() {
        return "1.8";
    }

    public String getServerVersionTag() {
        return "Spigot-CB-1.8_R1";
    }

    public CommandMap getCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public BlockCache getBlockCache(World world) {
        return new BlockCacheSpigotCB1_8_R1(world);
    }

    public double getHeight(Entity entity) {
        net.minecraft.server.v1_8_R1.Entity mcEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB boundingBox = mcEntity.getBoundingBox();
        double entityHeight = Math.max((double)mcEntity.length, Math.max((double)mcEntity.getHeadHeight(), boundingBox.e - boundingBox.b));
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    public AlmostBoolean isBlockSolid(int id) {
        Block block = Block.getById((int)id);
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isSolid());
    }

    public AlmostBoolean isBlockLiquid(int id) {
        Block block = Block.getById((int)id);
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isLiquid());
    }

    public double getWidth(Entity entity) {
        return ((CraftEntity)entity).getHandle().width;
    }

    public AlmostBoolean isIllegalBounds(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.dead) {
            return AlmostBoolean.NO;
        }
        AxisAlignedBB box = entityPlayer.getBoundingBox();
        if (!entityPlayer.isSleeping()) {
            double dY = Math.abs(box.e - box.b);
            if (dY > 1.8) {
                return AlmostBoolean.YES;
            }
            if (dY < 0.1 && (double)entityPlayer.length >= 0.1) {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.MAYBE;
    }

    public double getJumpAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.JUMP)) {
            return mcPlayer.getEffect(MobEffectList.JUMP).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getFasterMovementAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            return mcPlayer.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getSpeedAttributeMultiplier(Player player) {
        AttributeInstance attr = ((CraftLivingEntity)player).getHandle().getAttributeInstance(GenericAttributes.d);
        double val = attr.getValue() / attr.b();
        AttributeModifier mod = attr.a(AttribUtil.ID_SPRINT_BOOST);
        if (mod == null) {
            return val;
        }
        return val / AttribUtil.getMultiplier(mod.c(), mod.d());
    }

    public double getSprintAttributeMultiplier(Player player) {
        AttributeModifier mod = ((CraftLivingEntity)player).getHandle().getAttributeInstance(GenericAttributes.d).a(AttribUtil.ID_SPRINT_BOOST);
        if (mod == null) {
            return 1.0;
        }
        return AttribUtil.getMultiplier(mod.c(), mod.d());
    }

    public int getInvulnerableTicks(Player player) {
        return ((CraftPlayer)player).getHandle().invulnerableTicks;
    }

    public void setInvulnerableTicks(Player player, int ticks) {
        ((CraftPlayer)player).getHandle().invulnerableTicks = ticks;
    }

    public void dealFallDamage(Player player, double damage) {
        ((CraftPlayer)player).getHandle().damageEntity(DamageSource.FALL, (float)damage);
    }

    public boolean isComplexPart(Entity entity) {
        return ((CraftEntity)entity).getHandle() instanceof EntityComplexPart;
    }

    public boolean shouldBeZombie(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        return !mcPlayer.dead && mcPlayer.getHealth() <= 0.0f;
    }

    public void setDead(Player player, int deathTicks) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        mcPlayer.deathTicks = deathTicks;
        mcPlayer.dead = true;
    }

    public boolean hasGravity(Material mat) {
        return mat.hasGravity();
    }

    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.YES;
    }
}

