/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.versions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerVersion {
    public static final String UNKNOWN_VERSION = "unknown";
    private static String minecraftVersion = "unknown";
    private static final String[][] versionTagsMatch = new String[][]{{"1.7.2-r", "1.7.2"}};

    public static String parseMinecraftVersion(String ... versionCandidates) {
        for (String serverVersion : versionCandidates) {
            serverVersion = serverVersion.trim();
            for (String minecraftVersion : new String[]{ServerVersion.collectVersion(serverVersion, 0), ServerVersion.parseMinecraftVersionGeneric(serverVersion), ServerVersion.parseMinecraftVersionTokens(serverVersion)}) {
                if (minecraftVersion == null || !ServerVersion.validateMinecraftVersion(minecraftVersion)) continue;
                return minecraftVersion;
            }
        }
        return null;
    }

    private static boolean validateMinecraftVersion(String minecraftVersion) {
        return ServerVersion.collectVersion(minecraftVersion, 0) != null;
    }

    private static String parseMinecraftVersionTokens(String serverVersion) {
        serverVersion = serverVersion.trim().toLowerCase();
        for (String[] entry : versionTagsMatch) {
            if (!serverVersion.contains(entry[0])) continue;
            return entry[1];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String collectVersion(String input, int beginIndex) {
        StringBuilder buffer = new StringBuilder(128);
        boolean numberFound = false;
        char[] chars = input.toCharArray();
        for (int i = beginIndex; i < input.length(); ++i) {
            char c = chars[i];
            if (c == '.') {
                if (!numberFound) return null;
                numberFound = false;
            } else {
                if (!Character.isDigit(c)) {
                    return null;
                }
                numberFound = true;
            }
            buffer.append(c);
        }
        if (!numberFound) return null;
        return buffer.toString();
    }

    private static String parseMinecraftVersionGeneric(String serverVersion) {
        String lcServerVersion = serverVersion.trim().toLowerCase();
        for (String candidate : new String[]{ServerVersion.parseVersionDelimiters(lcServerVersion, "(mc:", ")"), ServerVersion.parseVersionDelimiters(lcServerVersion, "mcpc-plus-", "-"), ServerVersion.parseVersionDelimiters(lcServerVersion, "git-bukkit-", "-r"), ServerVersion.parseVersionDelimiters(lcServerVersion, "", "-r")}) {
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private static String parseVersionDelimiters(String input, String prefix, String suffix) {
        int preIndex;
        int n = preIndex = prefix.isEmpty() ? 0 : input.indexOf(prefix);
        if (preIndex != -1) {
            int postIndex;
            String candidate = input.substring(preIndex + prefix.length());
            int n2 = postIndex = suffix.isEmpty() ? candidate.length() : candidate.indexOf(suffix);
            if (postIndex != -1) {
                return ServerVersion.collectVersion(candidate.substring(0, postIndex).trim(), 0);
            }
        }
        return null;
    }

    public static String setMinecraftVersion(String version) {
        minecraftVersion = version == null ? UNKNOWN_VERSION : ((version = version.trim().toLowerCase()).isEmpty() ? UNKNOWN_VERSION : version);
        return minecraftVersion;
    }

    public static String getMinecraftVersion() {
        return minecraftVersion;
    }

    public static int compareVersions(String version1, String version2) {
        if (version2.equals(UNKNOWN_VERSION)) {
            throw new IllegalArgumentException("version2 must not be 'unknown'.");
        }
        if (version1.equals(UNKNOWN_VERSION)) {
            return -1;
        }
        if (version1.equals(version2)) {
            return 0;
        }
        try {
            int[] v1Int = ServerVersion.versionToInt(version1);
            int[] v2Int = ServerVersion.versionToInt(version2);
            for (int i = 0; i < Math.min(v1Int.length, v2Int.length); ++i) {
                if (v1Int[i] < v2Int[i]) {
                    return -1;
                }
                if (v1Int[i] <= v2Int[i]) continue;
                return 1;
            }
            if (v1Int.length < v2Int.length) {
                return -1;
            }
            if (v1Int.length > v2Int.length) {
                return 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Bad version input.");
    }

    public static int[] versionToInt(String version) {
        String[] split = version.split("\\.");
        int[] num = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            num[i] = Integer.parseInt(split[i]);
        }
        return num;
    }

    public static <V> V select(String cmpVersion, V valueLT, V valueEQ, V valueGT, V valueUnknown) {
        String mcVersion = ServerVersion.getMinecraftVersion();
        if (mcVersion == UNKNOWN_VERSION) {
            return valueUnknown;
        }
        int cmp = ServerVersion.compareVersions(mcVersion, cmpVersion);
        if (cmp == 0) {
            return valueEQ;
        }
        if (cmp < 0) {
            return valueLT;
        }
        return valueGT;
    }
}

