/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public abstract class BlockCache {
    private static final int ID_AIR = 0;
    private final CoordMap<Integer> idMap = new CoordHashMap<Integer>(23);
    private final CoordMap<Integer> dataMap = new CoordHashMap<Integer>(23);
    private final CoordMap<double[]> boundsMap = new CoordHashMap<double[]>(23);
    protected int maxBlockY = 255;

    public static final boolean isFullBounds(double[] bounds) {
        if (bounds == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (bounds[i] > 0.0) {
                return false;
            }
            if (!(bounds[i + 3] < 1.0)) continue;
            return false;
        }
        return true;
    }

    public static int ensureChunksLoaded(World world, double x, double z, double xzMargin) {
        int loaded = 0;
        int minX = Location.locToBlock((double)(x - xzMargin)) / 16;
        int maxX = Location.locToBlock((double)(x + xzMargin)) / 16;
        int minZ = Location.locToBlock((double)(z - xzMargin)) / 16;
        int maxZ = Location.locToBlock((double)(z + xzMargin)) / 16;
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                if (world.isChunkLoaded(cx, cz)) continue;
                try {
                    world.loadChunk(cx, cz);
                    ++loaded;
                    continue;
                }
                catch (Exception ex) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, "Failed to load chunk at " + cx * 16 + "," + cz * 16 + " (real coordinates):\n" + StringUtil.throwableToString(ex));
                }
            }
        }
        return loaded;
    }

    public BlockCache() {
    }

    public BlockCache(World world) {
        this.setAccess(world);
    }

    public abstract void setAccess(World var1);

    public abstract int fetchTypeId(int var1, int var2, int var3);

    public abstract int fetchData(int var1, int var2, int var3);

    public abstract double[] fetchBounds(int var1, int var2, int var3);

    public abstract boolean standsOnEntity(Entity var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void cleanup() {
        this.idMap.clear();
        this.dataMap.clear();
        this.boundsMap.clear();
    }

    public int getTypeId(double x, double y, double z) {
        return this.getTypeId(Location.locToBlock((double)x), Location.locToBlock((double)y), Location.locToBlock((double)z));
    }

    public int getTypeId(Block block) {
        return this.getTypeId(block.getX(), block.getY(), block.getZ());
    }

    public int getTypeId(int x, int y, int z) {
        Integer pId = this.idMap.get(x, y, z);
        if (pId != null) {
            return pId;
        }
        Integer nId = y < 0 || y > this.maxBlockY ? 0 : this.fetchTypeId(x, y, z);
        this.idMap.put(x, y, z, nId);
        return nId;
    }

    public int getData(int x, int y, int z) {
        Integer pData = this.dataMap.get(x, y, z);
        if (pData != null) {
            return pData;
        }
        Integer nData = y < 0 || y > this.maxBlockY ? 0 : this.fetchData(x, y, z);
        this.dataMap.put(x, y, z, nData);
        return nData;
    }

    public double[] getBounds(int x, int y, int z) {
        double[] pBounds = this.boundsMap.get(x, y, z);
        if (pBounds != null) {
            return pBounds;
        }
        double[] nBounds = y < 0 || y > this.maxBlockY ? null : this.fetchBounds(x, y, z);
        this.boundsMap.put(x, y, z, nBounds);
        return nBounds;
    }

    public boolean isFullBounds(int x, int y, int z) {
        return BlockCache.isFullBounds(this.getBounds(x, y, z));
    }

    public int getMaxBlockY() {
        return this.maxBlockY;
    }
}

