/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TrigUtil {
    private static final Vector vec1 = new Vector();
    private static final Vector vec2 = new Vector();
    public static final double fRadToGrad = 57.29577951308232;
    public static final double DIRECTION_PRECISION = 2.6;
    public static final double DIRECTION_LOOP_PRECISION = 0.5;
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public static double directionCheck(Player player, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        Location loc = player.getLocation(useLoc);
        Vector dir = loc.getDirection();
        double res = TrigUtil.directionCheck(loc.getX(), loc.getY() + player.getEyeHeight(), loc.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision);
        useLoc.setWorld(null);
        return res;
    }

    public static double directionCheck(Location sourceFoot, double eyeHeight, Vector dir, Block target, double precision) {
        return TrigUtil.directionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), target.getX(), target.getY(), target.getZ(), 1.0, 1.0, precision);
    }

    public static double directionCheck(Location sourceFoot, double eyeHeight, Vector dir, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        return TrigUtil.directionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision);
    }

    public static double directionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        double targetDist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + precision), 0.0);
        off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + precision), 0.0);
        if ((off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + precision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }

    public static double combinedDirectionCheck(Location sourceFoot, double eyeHeight, Vector dir, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision, double anglePrecision) {
        return TrigUtil.combinedDirectionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision, anglePrecision);
    }

    public static double combinedDirectionCheck(Location sourceFoot, double eyeHeight, Vector dir, Block target, double precision, double anglePrecision) {
        return TrigUtil.combinedDirectionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), target.getX(), target.getY(), target.getZ(), 1.0, 1.0, precision, anglePrecision);
    }

    public static double combinedDirectionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double blockPrecision, double anglePrecision) {
        double dZ;
        double dY;
        double dX;
        double targetDist;
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        if ((targetDist = Math.sqrt((dX = targetX - sourceX) * dX + (dY = targetY - sourceY) * dY + (dZ = targetZ - sourceZ) * dZ)) > Math.max(targetHeight, targetWidth) / 2.0 && (double)TrigUtil.angle(sourceX, sourceY, sourceZ, dirX, dirY, dirZ, targetX, targetY, targetZ) * 57.29577951308232 > anglePrecision) {
            return targetDist - Math.max(targetHeight, targetWidth) / 2.0;
        }
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + blockPrecision), 0.0);
        off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + blockPrecision), 0.0);
        if ((off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + blockPrecision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }

    public static final double distance(Location location1, Location location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(PlayerLocation location1, Location location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(PlayerLocation location1, PlayerLocation location2) {
        return TrigUtil.distance(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distance(Location location, Block block) {
        return TrigUtil.distance(location.getX(), location.getY(), location.getZ(), 0.5 + (double)block.getX(), 0.5 + (double)block.getY(), 0.5 + (double)block.getZ());
    }

    public static final double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        double dz = Math.abs(z1 - z2);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static final double distanceSquared(Location location1, Location location2) {
        return TrigUtil.distanceSquared(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distanceSquared(PlayerLocation location1, PlayerLocation location2) {
        return TrigUtil.distanceSquared(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distanceSquared(PlayerLocation location1, Location location2) {
        return TrigUtil.distanceSquared(location1.getX(), location1.getY(), location1.getZ(), location2.getX(), location2.getY(), location2.getZ());
    }

    public static final double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        double dz = Math.abs(z1 - z2);
        return dx * dx + dy * dy + dz * dz;
    }

    public static final double distanceSquared(double x1, double z1, double x2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dz = Math.abs(z1 - z2);
        return dx * dx + dz * dz;
    }

    public static final double xzDistance(Location location1, Location location2) {
        return TrigUtil.distance(location1.getX(), location1.getZ(), location2.getX(), location2.getZ());
    }

    public static final double xzDistance(PlayerLocation location1, PlayerLocation location2) {
        return TrigUtil.distance(location1.getX(), location1.getZ(), location2.getX(), location2.getZ());
    }

    public static final double distance(double x1, double z1, double x2, double z2) {
        double dx = Math.abs(x1 - x2);
        double dz = Math.abs(z1 - z2);
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static float angle(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ) {
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        vec1.setX(dX);
        vec1.setY(dY);
        vec1.setZ(dZ);
        vec2.setX(dirX);
        vec2.setY(dirY);
        vec2.setZ(dirZ);
        return vec2.angle(vec1);
    }

    public static final double angle(double x, double z) {
        double a;
        if (x > 0.0) {
            a = Math.atan(z / x);
        } else if (x < 0.0) {
            a = Math.atan(z / x) + Math.PI;
        } else if (z < 0.0) {
            a = 4.71238898038469;
        } else if (z > 0.0) {
            a = 1.5707963267948966;
        } else {
            return Double.NaN;
        }
        if (a < 0.0) {
            return a + Math.PI * 2;
        }
        return a;
    }

    public static final double angleDiff(double a1, double a2) {
        if (Double.isNaN(a1) || Double.isNaN(a1)) {
            return Double.NaN;
        }
        double diff = a2 - a1;
        if (diff < -Math.PI) {
            return diff + Math.PI * 2;
        }
        if (diff > Math.PI) {
            return diff - Math.PI * 2;
        }
        return diff;
    }

    public static final float yawDiff(float fromYaw, float toYaw) {
        if (fromYaw <= -360.0f) {
            fromYaw = -(-fromYaw % 360.0f);
        } else if (fromYaw >= 360.0f) {
            fromYaw %= 360.0f;
        }
        if (toYaw <= -360.0f) {
            toYaw = -(-toYaw % 360.0f);
        } else if (toYaw >= 360.0f) {
            toYaw %= 360.0f;
        }
        float yawDiff = toYaw - fromYaw;
        if (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        } else if (yawDiff > 180.0f) {
            yawDiff -= 360.0f;
        }
        return yawDiff;
    }

    public static int manhattan(Location loc1, Location loc2) {
        return TrigUtil.manhattan(loc1.getBlockX(), loc1.getBlockY(), loc1.getBlockZ(), loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
    }

    public static int manhattan(int x1, int y1, int z1, Block block) {
        return TrigUtil.manhattan(x1, y1, z1, block.getX(), block.getY(), block.getZ());
    }

    public static double manhattan(double x1, double z1, double x2, double z2) {
        return TrigUtil.manhattan((double)Location.locToBlock((double)x1), (double)Location.locToBlock((double)z1), (double)Location.locToBlock((double)x2), Location.locToBlock((double)z2));
    }

    public static int manhattan(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2) + Math.abs(z1 - z2);
    }

    public static double manhattan(double x1, double y1, double z1, double x2, double y2, double z2) {
        return TrigUtil.manhattan(Location.locToBlock((double)x1), Location.locToBlock((double)y1), Location.locToBlock((double)z1), Location.locToBlock((double)x2), Location.locToBlock((double)y2), Location.locToBlock((double)z2));
    }

    public static int maxDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Math.max(Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)), Math.abs(z1 - z2));
    }

    public static double maxDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.max(Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)), Math.abs(z1 - z2));
    }

    public static boolean isMovingBackwards(double xDistance, double zDistance, float yaw) {
        return xDistance < 0.0 && zDistance > 0.0 && yaw > 180.0f && yaw < 270.0f || xDistance < 0.0 && zDistance < 0.0 && yaw > 270.0f && yaw < 360.0f || xDistance > 0.0 && zDistance < 0.0 && yaw > 0.0f && yaw < 90.0f || xDistance > 0.0 && zDistance > 0.0 && yaw > 90.0f && yaw < 180.0f;
    }

    public static boolean isSamePosAndLook(Location loc1, Location loc2) {
        return TrigUtil.isSamePos(loc1, loc2) && loc1.getPitch() == loc2.getPitch() && loc1.getYaw() == loc2.getYaw();
    }

    public static boolean isSamePos(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null) {
            return false;
        }
        return loc1.getX() == loc2.getX() && loc1.getZ() == loc2.getZ() && loc1.getY() == loc2.getY();
    }

    public static boolean isSamePos(Location loc, double x, double y, double z) {
        if (loc == null) {
            return false;
        }
        return loc.getX() == x && loc.getZ() == z && loc.getY() == y;
    }

    public static boolean isSamePos(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2;
    }

    public static boolean isSamePos(double x1, double z1, double x2, double z2) {
        return x1 == x2 && z1 == z2;
    }

    public static boolean isSameBlock(Location loc, double x, double y, double z) {
        if (loc == null) {
            return false;
        }
        return loc.getBlockX() == Location.locToBlock((double)x) && loc.getBlockZ() == Location.locToBlock((double)z) && loc.getBlockY() == Location.locToBlock((double)y);
    }

    public static boolean isSameBlock(int x1, int y1, int z1, double x2, double y2, double z2) {
        return x1 == Location.locToBlock((double)x2) && z1 == Location.locToBlock((double)z2) && y1 == Location.locToBlock((double)y2);
    }
}

