/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.build;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static String fetchResource(Class<?> clazz, String path) {
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        String absPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/" + path;
        try {
            URL url = new URL(absPath);
            BufferedReader r = null;
            try {
                Object obj = url.getContent();
                if (obj instanceof InputStream) {
                    r = new BufferedReader(new InputStreamReader((InputStream)obj));
                    StringBuilder builder = new StringBuilder();
                    String last = r.readLine();
                    while (last != null) {
                        builder.append(last);
                        builder.append("\n");
                        last = r.readLine();
                    }
                    r.close();
                    return builder.toString();
                }
                return null;
            }
            catch (IOException e) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static void parseToMap(String input, Map<String, String> map) {
        String[] split;
        for (String line : split = input.split("\n")) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
            String[] parts = line.split("=", 2);
            if (parts.length == 1) {
                map.put(parts[0].trim(), "");
                continue;
            }
            map.put(parts[0].trim(), parts[1].trim());
        }
    }

    public static Boolean getBoolean(String input, Boolean preset) {
        if (input == null) {
            return preset;
        }
        if ((input = input.trim().toLowerCase()).matches("1|true|yes")) {
            return true;
        }
        if (input.matches("0|false|no")) {
            return false;
        }
        return preset;
    }

    public static Integer getInteger(String input, Integer preset) {
        if (input == null) {
            return preset;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            return preset;
        }
    }
}

