/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Command;

import io.github.apfelcreme.Pipes.Command.SubCommand;
import io.github.apfelcreme.Pipes.LoopDetection.Detection;
import io.github.apfelcreme.Pipes.LoopDetection.TickingLocation;
import io.github.apfelcreme.Pipes.Manager.DetectionManager;
import io.github.apfelcreme.Pipes.Pipes;
import io.github.apfelcreme.Pipes.PipesConfig;
import io.github.apfelcreme.Pipes.PipesUtil;
import java.text.DecimalFormat;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DetectCommand
implements SubCommand {
    @Override
    public void execute(final CommandSender commandSender, String[] strings) {
        if (commandSender.hasPermission("Pipes.detect")) {
            long duration = 200L;
            if (strings.length > 1 && PipesUtil.isNumeric(strings[1])) {
                duration = 20L * (long)Integer.parseInt(strings[1]);
            }
            DetectionManager.getInstance().createDetection(commandSender);
            Pipes.sendMessage(commandSender, PipesConfig.getText("info.detect.started").replace("{0}", new DecimalFormat("0").format(duration / 20L)));
            Pipes.getInstance().getServer().getScheduler().runTaskLaterAsynchronously((Plugin)Pipes.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Detection detection = DetectionManager.getInstance().getDetection(commandSender);
                    if (detection != null) {
                        List<TickingLocation> result = detection.getResult();
                        if (!result.isEmpty()) {
                            Pipes.sendMessage(commandSender, PipesConfig.getText("info.detect.finished"));
                            int i = 0;
                            for (TickingLocation tickingLocation : result) {
                                Pipes.sendMessage(commandSender, PipesConfig.getText("info.detect.element").replace("{0}", String.valueOf(i)).replace("{1}", String.valueOf(tickingLocation.getLocation().getWorldName())).replace("{2}", String.valueOf(tickingLocation.getLocation().getX())).replace("{3}", String.valueOf(tickingLocation.getLocation().getY())).replace("{4}", String.valueOf(tickingLocation.getLocation().getZ())).replace("{5}", String.valueOf(tickingLocation.getTimesTicked())));
                                ++i;
                            }
                        } else {
                            Pipes.sendMessage(commandSender, PipesConfig.getText("info.detect.noElements"));
                        }
                    }
                }
            }, duration);
        } else {
            Pipes.sendMessage(commandSender, PipesConfig.getText("error.noPermission"));
        }
    }
}

