/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Listener;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.listeners.BlockBreakLogging;
import io.github.apfelcreme.Pipes.Event.PipeBlockBreakEvent;
import io.github.apfelcreme.Pipes.Exception.ChunkNotLoadedException;
import io.github.apfelcreme.Pipes.Manager.PipeManager;
import io.github.apfelcreme.Pipes.Pipe.Pipe;
import io.github.apfelcreme.Pipes.Pipes;
import io.github.apfelcreme.Pipes.PipesConfig;
import io.github.apfelcreme.Pipes.PipesItem;
import io.github.apfelcreme.Pipes.PipesUtil;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BlockListener
implements Listener {
    private final Pipes plugin;
    private BlockBreakLogging blockBreakLogging;

    public BlockListener(Pipes plugin) {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager().isPluginEnabled("LogBlock")) {
            this.blockBreakLogging = new BlockBreakLogging(LogBlock.getInstance());
        }
    }

    @EventHandler
    private void onItemDispense(BlockDispenseEvent event) {
        if (PipesUtil.getPipesItem(event.getBlock()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryMove(InventoryMoveItemEvent event) {
        if (event.getSource().getHolder() instanceof BlockState && PipesItem.PIPE_OUTPUT.check(((BlockState)event.getSource().getHolder()).getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onBlockBreak(BlockBreakEvent event) {
        PipesItem pipesItem = PipesUtil.getPipesItem(event.getBlock());
        if (pipesItem != null) {
            event.setCancelled(true);
            PipeBlockBreakEvent blockBreakEvent = new PipeBlockBreakEvent(event.getBlock(), event.getPlayer(), pipesItem);
            this.plugin.getServer().getPluginManager().callEvent((Event)blockBreakEvent);
            if (!blockBreakEvent.isCancelled()) {
                if (this.blockBreakLogging != null) {
                    this.blockBreakLogging.onBlockBreak(new BlockBreakEvent(blockBreakEvent.getBlock(), event.getPlayer()));
                }
                event.getBlock().setType(Material.AIR);
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), pipesItem.toItemStack());
            }
        }
    }

    @EventHandler
    private void onBlockPlace(BlockPlaceEvent event) {
        if (PipesUtil.getPipesItem(event.getBlock()) != null) {
            if (event.getBlock().getType() == PipesItem.CHUNK_LOADER.getMaterial() && !event.getPlayer().hasPermission("Pipes.placeChunkLoader")) {
                Pipes.sendMessage((CommandSender)event.getPlayer(), PipesConfig.getText("error.noPermission"));
                event.setCancelled(true);
                return;
            }
            try {
                Pipe pipe = PipeManager.isPipe(event.getBlock());
                if (pipe != null) {
                    Pipes.sendMessage((CommandSender)event.getPlayer(), PipesConfig.getText("info.pipe.pipeBuilt").replace("{0}", pipe.getString()));
                    pipe.highlight();
                }
            }
            catch (ChunkNotLoadedException e) {
                Pipes.sendMessage((CommandSender)event.getPlayer(), PipesConfig.getText("error.chunkNotLoaded"));
            }
        }
    }

    @EventHandler
    public void onItemCraft(CraftItemEvent event) {
        if (PipesUtil.getPipesItem(event.getCurrentItem()) == PipesItem.CHUNK_LOADER && !event.getWhoClicked().hasPermission("Pipes.placeChunkLoader")) {
            event.setCancelled(true);
            Pipes.sendMessage((CommandSender)event.getWhoClicked(), PipesConfig.getText("error.noPermission"));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item;
        if (event.getInventory().getType() != InventoryType.ANVIL || event.getResult() == Event.Result.DENY || event.getSlotType() != InventoryType.SlotType.RESULT || !event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName()) {
            return;
        }
        if (event.getInventory().getContents().length > 0 && (item = event.getInventory().getContents()[0]) != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(event.getCurrentItem().getItemMeta().getDisplayName())) {
            return;
        }
        PipesItem pipesItem = PipesUtil.getPipesItem(event.getCurrentItem());
        if (pipesItem == null) {
            return;
        }
        ItemMeta resultMeta = event.getCurrentItem().getItemMeta();
        if (PipesUtil.getHiddenString(resultMeta.getDisplayName()) != null) {
            return;
        }
        resultMeta.setDisplayName(PipesUtil.hideString(pipesItem.toString(), resultMeta.getDisplayName()));
        event.getCurrentItem().setItemMeta(resultMeta);
    }
}

