/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Listener;

import io.github.apfelcreme.Pipes.Event.PipeMoveItemEvent;
import io.github.apfelcreme.Pipes.Manager.ItemMoveScheduler;
import io.github.apfelcreme.Pipes.Manager.PipeManager;
import io.github.apfelcreme.Pipes.Pipe.Pipe;
import io.github.apfelcreme.Pipes.Pipe.PipeInput;
import io.github.apfelcreme.Pipes.Pipe.ScheduledItemTransfer;
import io.github.apfelcreme.Pipes.Pipe.SimpleLocation;
import io.github.apfelcreme.Pipes.Pipes;
import io.github.apfelcreme.Pipes.PipesItem;
import io.github.apfelcreme.Pipes.PipesUtil;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryChangeListener
implements Listener {
    private final Pipes plugin;

    public InventoryChangeListener(Pipes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onInventoryItemMove(InventoryMoveItemEvent event) {
        if (!(event instanceof PipeMoveItemEvent) && !this.handleInventoryAction(event.getDestination(), true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onInventoryClose(InventoryCloseEvent event) {
        this.handleInventoryAction(event.getInventory(), false);
    }

    private boolean handleInventoryAction(Inventory inventory, boolean scheduled) {
        if (!(inventory.getHolder() instanceof BlockState)) {
            return true;
        }
        Block dispenserBlock = ((BlockState)inventory.getHolder()).getBlock();
        if (!PipesItem.PIPE_INPUT.check(dispenserBlock)) {
            return true;
        }
        SimpleLocation dispenserLocation = new SimpleLocation(dispenserBlock.getLocation());
        Pipe pipe = PipeManager.getInstance().getPipe(dispenserLocation);
        if (pipe == null) {
            return false;
        }
        PipeInput pipeInput = pipe.getInput(dispenserLocation);
        if (pipeInput != null) {
            final ScheduledItemTransfer transfer = new ScheduledItemTransfer(dispenserLocation);
            if (scheduled) {
                new BukkitRunnable(){

                    public void run() {
                        ItemMoveScheduler.getInstance().add(transfer);
                    }
                }.runTaskLater((Plugin)this.plugin, 2L);
            } else {
                ItemMoveScheduler.getInstance().add(transfer);
            }
        }
        return true;
    }

    @EventHandler
    private void onHopperTransfer(InventoryMoveItemEvent event) {
        if (event.getInitiator().getType() == InventoryType.HOPPER && (event.getSource().getType() == InventoryType.DISPENSER || event.getSource().getType() == InventoryType.DROPPER) && event.getSource().getHolder() instanceof BlockState && PipesUtil.getPipesItem(((BlockState)event.getSource().getHolder()).getBlock()) != null) {
            event.setCancelled(true);
        }
    }
}

