/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Manager;

import io.github.apfelcreme.Pipes.Pipe.ScheduledItemTransfer;
import io.github.apfelcreme.Pipes.Pipe.SimpleLocation;
import io.github.apfelcreme.Pipes.Pipes;
import io.github.apfelcreme.Pipes.PipesConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ItemMoveScheduler {
    private int taskId = -1;
    private List<ScheduledItemTransfer> scheduledItemTransfers = new ArrayList<ScheduledItemTransfer>();
    private int emptyRuns = 0;
    private static ItemMoveScheduler instance = null;

    private ItemMoveScheduler() {
    }

    public static ItemMoveScheduler getInstance() {
        if (instance == null) {
            instance = new ItemMoveScheduler();
        }
        return instance;
    }

    private void create() {
        this.taskId = Pipes.getInstance().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Pipes.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (!ItemMoveScheduler.this.scheduledItemTransfers.isEmpty()) {
                    Iterator transfers = ItemMoveScheduler.this.scheduledItemTransfers.iterator();
                    while (transfers.hasNext()) {
                        if (!((ScheduledItemTransfer)transfers.next()).execute()) continue;
                        transfers.remove();
                    }
                } else {
                    ItemMoveScheduler.this.emptyRuns++;
                    if (ItemMoveScheduler.this.emptyRuns >= 3) {
                        ItemMoveScheduler.this.kill();
                    }
                }
            }
        }, 20L, PipesConfig.getTransferCooldown());
    }

    private void kill() {
        Pipes.getInstance().getServer().getScheduler().cancelTask(this.taskId);
        this.taskId = -1;
        this.emptyRuns = 0;
    }

    public boolean isActive() {
        return this.taskId != -1;
    }

    public void add(ScheduledItemTransfer scheduledItemTransfer) {
        this.emptyRuns = 0;
        if (!this.scheduledItemTransfers.contains(scheduledItemTransfer)) {
            this.scheduledItemTransfers.add(scheduledItemTransfer);
        }
        if (!this.isActive() && !this.scheduledItemTransfers.isEmpty()) {
            this.create();
        }
    }

    public List<ScheduledItemTransfer> getTransfers() {
        return this.scheduledItemTransfers;
    }

    public static void load() {
        YamlConfiguration oldTransfers = YamlConfiguration.loadConfiguration((File)new File(Pipes.getInstance().getDataFolder(), "transfers.yml"));
        for (Map locMap : oldTransfers.getMapList("transfers")) {
            try {
                SimpleLocation location = SimpleLocation.deserialize(locMap);
                ItemMoveScheduler.getInstance().add(new ScheduledItemTransfer(location));
            }
            catch (IllegalArgumentException e) {
                Pipes.getInstance().getLogger().log(Level.SEVERE, "Could not load transfer from transfers.yml: " + e.getMessage());
            }
        }
        Pipes.getInstance().getLogger().log(Level.INFO, "Loaded " + ItemMoveScheduler.getInstance().getTransfers().size() + " scheduled transfers.");
    }

    public static void exit() {
        ItemMoveScheduler.getInstance().kill();
        YamlConfiguration oldTransfers = new YamlConfiguration();
        ArrayList<Map<String, Object>> transferList = new ArrayList<Map<String, Object>>();
        for (ScheduledItemTransfer transfer : ItemMoveScheduler.getInstance().getTransfers()) {
            transferList.add(transfer.getInputLocation().serialize());
        }
        oldTransfers.set("transfers", transferList);
        try {
            oldTransfers.save(new File(Pipes.getInstance().getDataFolder(), "transfers.yml"));
            Pipes.getInstance().getLogger().log(Level.INFO, "Saved " + transferList.size() + " scheduled transfers.");
        }
        catch (IOException e) {
            Pipes.getInstance().getLogger().log(Level.SEVERE, "Could not write transfers to transfers.yml", e);
        }
    }
}

