/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Manager;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.apfelcreme.Pipes.Exception.ChunkNotLoadedException;
import io.github.apfelcreme.Pipes.Pipe.ChunkLoader;
import io.github.apfelcreme.Pipes.Pipe.Pipe;
import io.github.apfelcreme.Pipes.Pipe.PipeInput;
import io.github.apfelcreme.Pipes.Pipe.PipeOutput;
import io.github.apfelcreme.Pipes.Pipe.SimpleLocation;
import io.github.apfelcreme.Pipes.Pipes;
import io.github.apfelcreme.Pipes.PipesConfig;
import io.github.apfelcreme.Pipes.PipesItem;
import io.github.apfelcreme.Pipes.PipesUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Directional;

public class PipeManager {
    private static PipeManager instance = null;
    private final LoadingCache<SimpleLocation, Pipe> pipeCache = CacheBuilder.newBuilder().expireAfterWrite(PipesConfig.getPipeCacheDuration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<SimpleLocation, Pipe>(){

        public Pipe load(SimpleLocation location) throws Exception {
            Pipe pipe = PipeManager.isPipe(location.getBlock());
            if (pipe == null) {
                throw new Exception("No pipe found!");
            }
            return pipe;
        }
    });

    private PipeManager() {
    }

    public Cache<SimpleLocation, Pipe> getPipeCache() {
        return this.pipeCache;
    }

    public static PipeManager getInstance() {
        if (instance == null) {
            instance = new PipeManager();
        }
        return instance;
    }

    public Pipe getPipe(SimpleLocation location) {
        try {
            return (Pipe)this.pipeCache.get((Object)location);
        }
        catch (ExecutionException e) {
            Pipes.getInstance().getLogger().log(Level.WARNING, "Error while trying to get a pipe from the cache.", e);
            return null;
        }
    }

    public static Pipe isPipe(Block startingPoint) throws ChunkNotLoadedException {
        LinkedList<SimpleLocation> queue = new LinkedList<SimpleLocation>();
        ArrayList<Block> found = new ArrayList<Block>();
        ArrayList<PipeInput> inputs = new ArrayList<PipeInput>();
        ArrayList<PipeOutput> outputs = new ArrayList<PipeOutput>();
        ArrayList<ChunkLoader> chunkLoaders = new ArrayList<ChunkLoader>();
        ArrayList<SimpleLocation> pipeBlocks = new ArrayList<SimpleLocation>();
        DyeColor color = null;
        World world = startingPoint.getWorld();
        queue.add(new SimpleLocation(startingPoint.getWorld().getName(), startingPoint.getX(), startingPoint.getY(), startingPoint.getZ()));
        while (!queue.isEmpty()) {
            SimpleLocation location = (SimpleLocation)queue.remove();
            if (!world.isChunkLoaded(location.getX() >> 4, location.getZ() >> 4) && chunkLoaders.size() == 0) {
                throw new ChunkNotLoadedException(location);
            }
            Block block = world.getBlockAt(location.getX(), location.getY(), location.getZ());
            if (found.contains(block)) continue;
            if (block.getType() == Material.STAINED_GLASS) {
                DyeColor blockColor = DyeColor.getByWoolData((byte)block.getState().getRawData());
                if (color == null) {
                    color = blockColor;
                }
                if (color != blockColor) continue;
                pipeBlocks.add(location);
                found.add(block);
                queue.add(location.getRelative(BlockFace.NORTH));
                queue.add(location.getRelative(BlockFace.EAST));
                queue.add(location.getRelative(BlockFace.SOUTH));
                queue.add(location.getRelative(BlockFace.WEST));
                queue.add(location.getRelative(BlockFace.UP));
                queue.add(location.getRelative(BlockFace.DOWN));
                continue;
            }
            PipesItem pipesItem = PipesUtil.getPipesItem(block);
            if (pipesItem == null) continue;
            switch (pipesItem) {
                case PIPE_INPUT: {
                    Block relativeToInput = block.getRelative(((Directional)block.getState().getData()).getFacing());
                    if (relativeToInput.getType() != Material.STAINED_GLASS) break;
                    inputs.add(new PipeInput(location));
                    found.add(block);
                    queue.add(new SimpleLocation(relativeToInput.getLocation()));
                    break;
                }
                case PIPE_OUTPUT: {
                    Block relativeToOutput = block.getRelative(((Directional)block.getState().getData()).getFacing());
                    if (!(relativeToOutput.getState() instanceof InventoryHolder)) break;
                    outputs.add(new PipeOutput(location, new SimpleLocation(relativeToOutput.getLocation())));
                    found.add(block);
                    found.add(relativeToOutput);
                    break;
                }
                case CHUNK_LOADER: {
                    chunkLoaders.add(new ChunkLoader(location));
                    found.add(block);
                }
            }
        }
        if (outputs.size() > 0 && inputs.size() > 0 && pipeBlocks.size() > 0) {
            return new Pipe(inputs, outputs, chunkLoaders, pipeBlocks, color);
        }
        return null;
    }

    @Deprecated
    public static boolean isPipeInput(BlockState state) {
        return PipesItem.PIPE_INPUT.check(state.getBlock());
    }

    @Deprecated
    public static boolean isPipeOutput(BlockState holder) {
        return PipesItem.PIPE_OUTPUT.check(holder.getBlock());
    }

    @Deprecated
    public static boolean isChunkLoader(BlockState holder) {
        return PipesItem.CHUNK_LOADER.check(holder.getBlock());
    }

    @Deprecated
    public static boolean isPipeInput(SimpleLocation location) {
        return PipesItem.PIPE_INPUT.check(location.getBlock());
    }

    @Deprecated
    public static boolean isPipeOutput(SimpleLocation location) {
        return PipesItem.PIPE_OUTPUT.check(location.getBlock());
    }

    @Deprecated
    public static boolean isChunkLoader(SimpleLocation location) {
        return PipesItem.CHUNK_LOADER.check(location.getBlock());
    }
}

