/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Pipe;

import io.github.apfelcreme.Pipes.Pipe.ChunkLoader;
import io.github.apfelcreme.Pipes.Pipe.PipeInput;
import io.github.apfelcreme.Pipes.Pipe.PipeOutput;
import io.github.apfelcreme.Pipes.Pipe.SimpleLocation;
import io.github.apfelcreme.Pipes.PipesConfig;
import io.github.apfelcreme.Pipes.PipesUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class Pipe {
    private final List<PipeInput> inputs;
    private final List<PipeOutput> outputs;
    private final List<ChunkLoader> chunkLoaders;
    private final List<SimpleLocation> pipeBlocks;
    private final DyeColor color;

    public Pipe(List<PipeInput> inputs, List<PipeOutput> outputs, List<ChunkLoader> chunkLoaders, List<SimpleLocation> pipeBlocks, DyeColor color) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.chunkLoaders = chunkLoaders;
        this.pipeBlocks = pipeBlocks;
        this.color = color;
    }

    public List<PipeInput> getInputs() {
        return this.inputs;
    }

    public List<PipeOutput> getOutputs() {
        return this.outputs;
    }

    public List<PipeOutput> getOutputs(InventoryType inventoryType, boolean filtering) {
        ArrayList<PipeOutput> sorterOutputs = new ArrayList<PipeOutput>();
        for (PipeOutput output : this.outputs) {
            InventoryHolder holder;
            InventoryHolder targetHolder = output.getTargetHolder();
            if (inventoryType != null && (targetHolder == null || targetHolder.getInventory().getType() != inventoryType) || (!filtering || output.getFilterItems().isEmpty()) && (filtering || !output.getFilterItems().isEmpty()) || (holder = output.getOutputHolder()) == null || ((BlockState)holder).getBlock().isBlockPowered()) continue;
            sorterOutputs.add(output);
        }
        return sorterOutputs;
    }

    public List<PipeOutput> getOutputs(ItemStack item) {
        ArrayList<PipeOutput> filteredOutputs = new ArrayList<PipeOutput>();
        ArrayList<PipeOutput> unfilteredOutputs = new ArrayList<PipeOutput>();
        for (PipeOutput output : this.outputs) {
            InventoryHolder holder = output.getOutputHolder();
            if (holder == null || ((BlockState)holder).getBlock().isBlockPowered()) continue;
            if (output.getFilterItems().isEmpty()) {
                unfilteredOutputs.add(output);
                continue;
            }
            if (!PipesUtil.containsSimilar(output.getFilterItems(), item)) continue;
            filteredOutputs.add(output);
        }
        return filteredOutputs.isEmpty() ? unfilteredOutputs : filteredOutputs;
    }

    public List<ChunkLoader> getChunkLoaders() {
        return this.chunkLoaders;
    }

    public List<SimpleLocation> getPipeBlocks() {
        return this.pipeBlocks;
    }

    public PipeInput getInput(SimpleLocation location) {
        for (PipeInput pipeInput : this.inputs) {
            if (!pipeInput.getLocation().equals(location)) continue;
            return pipeInput;
        }
        return null;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void highlight() {
        ArrayList<SimpleLocation> locations = new ArrayList<SimpleLocation>();
        for (SimpleLocation simpleLocation : this.pipeBlocks) {
            locations.add(simpleLocation);
        }
        for (PipeInput input : this.inputs) {
            locations.add(input.getLocation());
        }
        for (PipeOutput output : this.outputs) {
            locations.add(output.getLocation());
            locations.add(output.getTargetLocation());
        }
        for (SimpleLocation simpleLocation : locations) {
            Location location = simpleLocation.getLocation();
            location.setX(location.getX() + 0.5);
            location.setY(location.getY() + 0.5);
            location.setZ(location.getZ() + 0.5);
            for (int i = 0; i < 3; ++i) {
                location.getWorld().spigot().playEffect(location, Effect.FIREWORKS_SPARK, 0, 0, 0.1f, 0.1f, 0.1f, 0.0f, 1, 50);
            }
        }
    }

    public String getString() {
        return PipesConfig.getText("info.pipe.pipeData").replace("{0}", String.valueOf(this.inputs.size())).replace("{1}", String.valueOf(this.outputs.size())).replace("{2}", String.valueOf(this.pipeBlocks.size()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipe pipe = (Pipe)o;
        if (!this.inputs.equals(pipe.inputs)) {
            return false;
        }
        if (!this.outputs.equals(pipe.outputs)) {
            return false;
        }
        if (!this.chunkLoaders.equals(pipe.chunkLoaders)) {
            return false;
        }
        return this.pipeBlocks.equals(pipe.pipeBlocks);
    }

    public int hashCode() {
        int result = this.inputs.hashCode();
        result = 31 * result + this.outputs.hashCode();
        result = 31 * result + this.chunkLoaders.hashCode();
        result = 31 * result + this.pipeBlocks.hashCode();
        result = 31 * result + this.color.hashCode();
        return result;
    }
}

