/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Pipe;

import io.github.apfelcreme.Pipes.Pipe.SimpleLocation;
import io.github.apfelcreme.Pipes.PipesItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PipeOutput {
    private final SimpleLocation location;
    private final SimpleLocation targetLocation;

    public PipeOutput(SimpleLocation dropperLocation, SimpleLocation inventoryHolderLocation) {
        this.location = dropperLocation;
        this.targetLocation = inventoryHolderLocation;
    }

    public InventoryHolder getOutputHolder() {
        Block block = this.location.getBlock();
        if (PipesItem.PIPE_OUTPUT.check(block)) {
            return (InventoryHolder)block.getState();
        }
        return null;
    }

    public InventoryHolder getTargetHolder() {
        Block block = this.targetLocation.getBlock();
        if (block != null && block.getState() instanceof InventoryHolder) {
            return (InventoryHolder)block.getState();
        }
        return null;
    }

    public SimpleLocation getLocation() {
        return this.location;
    }

    public SimpleLocation getTargetLocation() {
        return this.targetLocation;
    }

    public List<ItemStack> getFilterItems() {
        ArrayList<ItemStack> sorterItems = new ArrayList<ItemStack>();
        InventoryHolder holder = this.getOutputHolder();
        if (holder != null) {
            for (ItemStack itemStack : holder.getInventory()) {
                if (itemStack == null) continue;
                sorterItems.add(itemStack);
            }
        }
        return sorterItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeOutput that = (PipeOutput)o;
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        return !(this.targetLocation == null ? that.targetLocation != null : !this.targetLocation.equals(that.targetLocation));
    }
}

